<div>
    <div class="max-w-xl">
        <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
            {{ __('user.language_preference') }}
        </label>
        @php
            $currentLang = $languages->firstWhere('code', $locale);
        @endphp
        <div class="relative" x-data="{ open: false }">
            <button
                @click="open = !open"
                type="button"
                class="relative w-full bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 text-start"
            >
                <span class="flex items-center gap-2">
                    @if($currentLang?->flag)
                        <span class="fi fi-{{ strtolower($currentLang->flag) }} fis rounded-sm"></span>
                    @endif
                    <span>{{ $currentLang?->name ?? __('common.select') }}</span>
                </span>
                <span class="absolute inset-y-0 end-0 flex items-center pe-2.5 pointer-events-none">
                    <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </span>
            </button>

            <div
                x-show="open"
                @click.away="open = false"
                x-transition:enter="transition ease-out duration-100"
                x-transition:enter-start="transform opacity-0 scale-95"
                x-transition:enter-end="transform opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-75"
                x-transition:leave-start="transform opacity-100 scale-100"
                x-transition:leave-end="transform opacity-0 scale-95"
                x-cloak
                class="absolute z-50 w-full mt-1 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg shadow-lg max-h-60 overflow-y-auto"
            >
                @foreach($languages as $language)
                    <button
                        type="button"
                        wire:click="$set('locale', '{{ $language->code }}')"
                        @click="open = false"
                        class="w-full flex items-center gap-2 px-3 py-2 text-sm text-start hover:bg-gray-100 dark:hover:bg-gray-600 {{ $locale === $language->code ? 'bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400' : 'text-gray-900 dark:text-white' }}"
                    >
                        <span class="fi fi-{{ strtolower($language->flag) }} fis rounded-sm"></span>
                        <span>{{ $language->name }}</span>
                        @if($locale === $language->code)
                            <svg class="w-4 h-4 ms-auto text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        @endif
                    </button>
                @endforeach
            </div>
        </div>
        <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
            {{ __('user.language_preference_description') }}
        </p>
    </div>
</div>
