<?php

return [
    // Page Titles
    'admin_overview' => 'Yönetici Genel Bakış',
    'overview_title' => 'Genel Bakış',
    'users_title' => 'Kullanıcılar',
    'subscriptions_title' => 'Abonelikler',
    'transactions_title' => 'İşlemler',
    'plans_title' => 'Planlar',
    'builders_title' => 'Derleyiciler',
    'plugins_title' => 'Eklentiler',
    'languages_title' => 'Diller',
    'cronjobs_title' => 'Zamanlanmış Görevler',
    'email_templates_title' => 'E-posta Şablonları',
    'audit_logs_title' => 'Denetim Kayıtları',
    'settings_title' => 'Ayarlar',

    // Page Subtitles
    'users_subtitle' => 'Platform kullanıcılarını ve hesaplarını yönetin',
    'subscriptions_subtitle' => 'Kullanıcı aboneliklerini ve faturalamayı izleyin',
    'transactions_subtitle' => 'Ödeme işlemlerini görüntüleyin ve yönetin',
    'plans_subtitle' => 'Abonelik planlarını ve fiyatlandırmayı yapılandırın',
    'builders_subtitle' => 'Uygulama derlemesi için derleyicileri yönetin',
    'plugins_subtitle' => 'Yüklü eklentileri yönetin',
    'languages_subtitle' => 'Kullanılabilir dilleri yönetin',
    'cronjobs_subtitle' => 'Zamanlanmış görevleri izleyin',
    'email_templates_subtitle' => 'Kullanıcılara gönderilen e-posta bildirimlerini özelleştirin',
    'cronjobs_subtitle_full' => 'Zamanlanmış görevleri ve otomasyonu izleyin',
    'settings_subtitle_full' => 'Sistem genelinde ayarları ve tercihleri yapılandırın',
    'search_settings' => 'Ayarlarda ara...',
    'no_settings_found' => 'Eşleşen ayar bulunamadı',
    'system_settings' => 'Sistem Ayarları',
    'clear_search' => 'Aramayı temizle',

    // Settings Sidebar Navigation
    'settings_section_general' => 'Genel',
    'settings_section_plans' => 'Planlar',
    'settings_section_auth' => 'Kimlik Doğrulama',
    'settings_section_email' => 'E-posta',
    'settings_section_privacy' => 'Gizlilik',
    'settings_section_preview' => 'Önizleme',
    'settings_section_ai' => 'Yapay Zeka Sohbet',
    'settings_category_platform' => 'Platform',
    'settings_category_security' => 'Güvenlik',
    'settings_category_integrations' => 'Entegrasyonlar',
    'audit_logs_subtitle' => 'GDPR uyumluluğu için kullanıcı eylemlerini ve sistem olaylarını takip edin',
    'no_audit_logs_found' => 'Denetim kaydı bulunamadı.',
    'search_audit_logs' => 'Kullanıcı, eylem, IP ara...',
    'date_time' => 'Tarih/Saat',
    'actor' => 'Aktör',
    'ip_address' => 'IP Adresi',
    'details' => 'Detaylar',
    'view_details' => 'Detayları Görüntüle',
    'system' => 'Sistem',
    'clear_filters' => 'Filtreleri temizle',
    'to' => '-',
    'settings_subtitle' => 'Sistem ayarlarını yapılandırın',

    // Users
    'add_user' => 'Kullanıcı Ekle',
    'edit_user' => 'Kullanıcıyı Düzenle',
    'create_user' => 'Kullanıcı Oluştur',
    'delete_user' => 'Kullanıcıyı Sil',
    'user_info' => 'Kullanıcı Bilgisi',
    'user_details' => 'Kullanıcı Detayları',
    'no_users_found' => 'Kullanıcı bulunamadı.',
    'search_users' => 'Kullanıcı ara...',
    'user_role' => 'Rol',
    'user_plan' => 'Plan',
    'user_joined' => 'Katıldı',
    'email_verified' => 'E-posta Doğrulandı',
    'mark_email_verified' => 'E-postayı doğrulanmış olarak işaretle',
    'role_admin' => 'Yönetici',
    'role_user' => 'Kullanıcı',
    'leave_blank_password' => 'Mevcut şifreyi korumak için boş bırakın',

    // Plans
    'add_plan' => 'Plan Ekle',
    'edit_plan' => 'Planı Düzenle',
    'create_plan' => 'Plan Oluştur',
    'create_new_plan' => 'Yeni Plan Oluştur',
    'update_plan' => 'Planı Güncelle',
    'delete_plan' => 'Planı Sil',
    'no_plans_found' => 'Plan bulunamadı.',
    'plan_features' => 'Özellikler',
    'plan_price' => 'Fiyat',
    'plan_interval' => 'Faturalama Aralığı',
    'monthly' => 'Aylık',
    'yearly' => 'Yıllık',
    'default_plan' => 'Varsayılan Plan',
    'mark_as_default' => 'Varsayılan plan olarak işaretle',
    'per_month' => '/ay',
    'subscribers' => 'abone',
    'plan_name' => 'Plan Adı',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Temel Bilgiler',
    'usage_limits' => 'Kullanım Limitleri',
    'monthly_build_credits' => 'Aylık Derleme Kredileri',
    'unlimited' => 'Sınırsız',
    'appetize_preview' => 'Appetize Önizleme',
    'hosted_pages' => 'Barındırılan Sayfalar',
    'ai_assistant' => 'Yapay Zeka Asistanı',
    'allow_own_api_keys' => 'Kendi API anahtarlarına izin ver',
    'permissions' => 'İzinler',
    'custom_css_js_injection' => 'Özel CSS/JS Ekleme',
    'api_access' => 'API Erişimi',
    'builder_access' => 'Derleyici Erişimi',
    'all_builders_allowed' => 'Tüm derleyicilere izin verildi',
    'select_builders' => 'Derleyici seç',
    'builders_selected' => ':count derleyici seçildi',
    'allow_all_builders' => 'Tüm Derleyicilere İzin Ver',
    'search_builders_placeholder' => 'Derleyici ara...',
    'features_pricing_display' => 'Özellikler (Fiyatlandırma Gösterimi)',
    'feature_name' => 'Özellik adı',
    'included' => 'Dahil',
    'not_included' => 'Dahil Değil',
    'no_features_added' => 'Henüz özellik eklenmedi. Fiyatlandırma sayfasında göstermek için özellik ekleyin.',

    // Subscriptions
    'add_subscription' => 'Abonelik Ekle',
    'subscription_details' => 'Abonelik Detayları',
    'no_subscriptions_found' => 'Abonelik bulunamadı.',
    'search_subscriptions' => 'Abonelik ara...',
    'renewal_date' => 'Yenilenme Tarihi',
    'subscription_status' => 'Durum',
    'change_plan' => 'Plan Değiştir',
    'cancel_subscription' => 'Aboneliği İptal Et',
    'next_billing' => 'Sonraki Faturalama',
    'no_plan' => 'Plan Yok',
    'select_user' => 'Kullanıcı seçin',
    'select_plan' => 'Plan seçin',
    'payment_method_placeholder' => 'Manuel, Banka Havalesi vb.',

    // Transactions
    'transaction_details' => 'İşlem Detayları',
    'no_transactions_found' => 'İşlem bulunamadı.',
    'search_transactions' => 'İşlem ara...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Tarih',
    'transaction_amount' => 'Tutar',
    'payment_method' => 'Ödeme Yöntemi',
    'payment_gateway' => 'ödeme ağ geçidi',
    'transaction_status' => 'Durum',
    'approve' => 'Onayla',
    'decline' => 'Reddet',
    'confirm_approval' => 'Onayı Onayla',
    'confirm_decline' => 'Reddi Onayla',
    'approve_payment' => 'Ödemeyi Onayla',
    'decline_payment' => 'Ödemeyi Reddet',
    'approve_bank_transfer_confirm' => 'Bu banka havalesi ödemesini onaylamak istediğinizden emin misiniz? Bu, kullanıcının aboneliğini etkinleştirecektir.',
    'decline_bank_transfer_confirm' => 'Bu banka havalesi ödemesini reddetmek istediğinizden emin misiniz? Bu, aboneliği iptal edecek ve kullanıcıya bildirim gönderecektir.',

    // Builders
    'add_builder' => 'Derleyici Ekle',
    'edit_builder' => 'Derleyiciyi Düzenle',
    'create_builder' => 'Derleyici Oluştur',
    'delete_builder' => 'Derleyiciyi Sil',
    'no_builders_found' => 'Derleyici bulunamadı.',
    'search_builders' => 'Derleyici ara...',
    'builder_name' => 'Derleyici Adı',
    'builder_url' => 'URL',
    'builder_status' => 'Durum',
    'builder_platform' => 'Platform',
    'builder_platforms' => 'Platformlar',
    'builder_name_placeholder' => 'Üretim Derleyicisi',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Oluşturulan sunucu anahtarı',
    'builder_queue' => 'Kuyruk',
    'current_builds' => 'Mevcut Derlemeler',
    'total_builds' => 'Toplam Derlemeler',
    'server_url' => 'Sunucu URL\'si',
    'port' => 'Port',
    'server_key' => 'Sunucu Anahtarı',
    'server_key_help' => 'Bu derleyiciye API isteklerini doğrulamak için kullanılır',
    'generate' => 'Oluştur',
    'max_queue' => 'Maksimum Kuyruk',
    'max_queue_help' => 'Maksimum eşzamanlı derleme',
    'build_credit_cost' => 'Derleme Kredi Maliyeti',
    'credit_cost_help' => 'Derleme başına düşülen kredi',
    'supported_platforms' => 'Desteklenen Platformlar',
    'select_platforms' => 'Platform seç',
    'platforms_selected' => ':count platform seçildi',
    'platforms_help' => 'Bu derleyicinin desteklediği bir veya daha fazla platform seçin',
    'no_platforms_available' => 'Kullanılabilir platform yok',
    'no_builders_configured' => 'Henüz derleyici yapılandırılmadı.',
    'default' => 'Varsayılan',
    'locked' => 'Kilitli',
    'from_purchase_code' => 'Satın alma kodundan',
    'purchase_code_not_set_warning' => 'Satın alma kodu yapılandırılmamış',
    'purchase_code_not_set_description' => 'Varsayılan derleyici geçerli bir satın alma kodu gerektirir. Lütfen Ayarlar > Genel bölümünde yapılandırın.',
    'server_key_from_purchase_code_help' => 'Sunucu anahtarı satın alma kodunuzdan otomatik olarak ayarlanır.',

    // Plugins
    'upload_plugin' => 'Eklenti Yükle',
    'configure_plugin' => 'Yapılandır',
    'delete_plugin' => 'Eklentiyi Sil',
    'no_plugins_found' => 'Eklenti bulunamadı.',
    'plugin_name' => 'Ad',
    'plugin_version' => 'Sürüm',
    'plugin_type' => 'Tür',
    'plugin_status' => 'Durum',

    // Languages
    'add_language' => 'Dil Ekle',
    'add_new_language' => 'Yeni Dil Ekle',
    'edit_language' => 'Dili Düzenle',
    'create_language' => 'Dil Oluştur',
    'delete_language' => 'Dili Sil',
    'no_languages_found' => 'Dil bulunamadı.',
    'cannot_delete_default_language' => 'Varsayılan veya birincil dil silinemez.',
    'default_language_badge' => 'Varsayılan',
    'language_name' => 'Dil Adı',
    'language_code' => 'Dil Kodu',
    'language_code_help' => '2 harfli ISO 639-1 kodu (örn., tr, en, de)',
    'language_code_from_folder' => 'Mevcut çeviri klasörlerinden seç',
    'language_flag' => 'Bayrak',
    'language_flag_help' => 'Ülke bayrağı emojisi',
    'language_flag_auto' => 'Bayrak, dil koduna göre otomatik ayarlanır',
    'language_flag_country_code_help' => '2 harfli ülke kodu (örn., tr, us, de)',
    'language_name_placeholder' => 'Türkçe',
    'language_code_placeholder' => 'tr',
    'language_flag_placeholder' => '🇹🇷',
    'language_status' => 'Durum',
    'rtl_support' => 'Metin Yönü',
    'rtl_enabled' => 'Sağdan Sola (RTL)',
    'rtl_description' => 'Arapça, İbranice, Farsça ve Urduca gibi diller için etkinleştirin',
    'translation_files_created' => 'Çeviri dosyaları şurada oluşturulacak: lang/:code/',
    'translation_files_auto_created' => 'Bu dili eklemeden önce :path konumunda çeviri dosyalarının mevcut olduğundan emin olun. lang/en/ klasörünü kopyalayın, dil kodunuza göre yeniden adlandırın ve içerikleri çevirin.',

    // Email Templates
    'edit_template' => 'Şablonu Düzenle',
    'edit_email_template' => 'E-posta Şablonunu Düzenle',
    'reset_template' => 'Varsayılana Sıfırla',
    'no_templates_found' => 'Şablon bulunamadı.',
    'template_subject' => 'Konu',
    'template_body' => 'İçerik',
    'template_variables' => 'Kullanılabilir Değişkenler',
    'subject_line' => 'Konu Satırı',
    'email_subject_placeholder' => 'E-posta konusu...',
    'email_body' => 'E-posta İçeriği',
    'click_to_insert' => 'İmleç konumuna eklemek için tıklayın',
    'no_variables_available' => 'Bu şablon için kullanılabilir değişken yok.',
    'quick_tips' => 'Hızlı İpuçları',
    'variables_replaced' => 'Değişkenler gönderildiğinde gerçek verilerle değiştirilir',
    'toolbar_format_tip' => 'Metni biçimlendirmek, bağlantı eklemek ve liste oluşturmak için araç çubuğunu kullanın',
    'link_tip' => 'Tıklanabilir bağlantı eklemek için metni seçin ve bağlantı düğmesine tıklayın',

    // Cronjobs
    'no_cronjobs_found' => 'Zamanlanmış görev bulunamadı.',
    'no_cron_logs_found' => 'Cron kaydı bulunamadı.',
    'search_logs' => 'Kayıtlarda ara...',
    'job_name' => 'Görev Adı',
    'job' => 'Görev',
    'last_run' => 'Son Çalışma',
    'next_run' => 'Sonraki Çalışma',
    'run_duration' => 'Süre',
    'started' => 'Başladı',
    'duration' => 'Süre',
    'triggered_by' => 'Tetikleyen',
    'message' => 'Mesaj',
    'all_jobs' => 'Tüm Görevler',
    'trigger_manually' => 'Manuel Tetikle',
    'status_success' => 'Başarılı',
    'status_running' => 'Çalışıyor',

    // Settings
    'general_settings' => 'Genel Ayarlar',
    'email_settings' => 'E-posta Ayarları',
    'social_login_settings' => 'Sosyal Giriş',
    'appetize_settings' => 'Appetize Ayarları',
    'ai_settings' => 'Yapay Zeka Ayarları',
    'gdpr_settings' => 'GDPR Ayarları',

    // General Settings Fields
    'site_name' => 'Site Adı',
    'site_description' => 'Site Açıklaması',
    'site_tagline' => 'Site Sloganı',
    'logo' => 'Logo',
    'logo_dark' => 'Koyu Mod Logosu',
    'favicon' => 'Favicon',
    'default_theme' => 'Varsayılan Tema',
    'landing_page_enabled' => 'Açılış Sayfasını Etkinleştir',
    'system_currency' => 'Sistem Para Birimi',
    'default_language' => 'Varsayılan Dil',
    'default_language_description' => 'Tercihi olmayan yeni ziyaretçiler ve kullanıcılar için varsayılan dil',

    // Status Labels
    'status_active' => 'Aktif',
    'status_inactive' => 'Pasif',
    'status_pending' => 'Beklemede',
    'status_expired' => 'Süresi Doldu',
    'status_cancelled' => 'İptal Edildi',
    'status_completed' => 'Tamamlandı',
    'status_failed' => 'Başarısız',

    // Demo Mode
    'demo_mode_notice' => 'Demo modunda ayarlar değiştirilemez.',
    'disabled_in_demo' => 'Demo modunda devre dışı',
    'hidden_in_demo' => 'Demo modunda gizli',

    // Plugins
    'plugins_title_full' => 'Eklentiler',
    'plugins_subtitle_full' => 'Özel eklentilerle işlevselliği genişletin',
    'no_plugins_installed' => 'Yüklü eklenti yok',
    'plugin_activate' => 'Etkinleştir',
    'plugin_deactivate' => 'Devre Dışı Bırak',
    'plugin_uninstall' => 'Kaldır',
    'plugin_author' => ':author tarafından',

    // Languages
    'languages_title_full' => 'Diller',
    'languages_subtitle_full' => 'Dil çevirilerini ve yerelleştirmeyi yönetin',

    // Cronjobs
    'cronjobs_title_full' => 'Zamanlanmış Görevler',
    'cronjobs_tab_jobs' => 'Zamanlanmış Görevler',
    'cronjobs_tab_logs' => 'Çalışma Kayıtları',
    'execute_job' => 'Çalıştır',
    'executing_job' => 'Çalıştırılıyor...',

    // Email Settings
    'email_config_title' => 'E-posta Yapılandırması',
    'email_config_subtitle' => 'E-posta ayarlarını ve SMTP sunucusunu yapılandırın',
    'mail_driver' => 'E-posta Sürücüsü',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail, sunucunuzun yerleşik e-posta yapılandırmasını kullanır. Basit ama bazı sunucularda teslimat sorunları yaşanabilir.',
    'php_mail_warning' => 'Not: Bazı barındırma sağlayıcıları PHP\'nin mail() işlevini devre dışı bırakır. E-postalar gönderilmiyorsa, SMTP\'ye geçmeyi düşünün.',
    'smtp_config' => 'SMTP Sunucu Yapılandırması',
    'smtp_host' => 'SMTP Sunucusu',
    'smtp_port' => 'SMTP Portu',
    'smtp_username' => 'SMTP Kullanıcı Adı',
    'smtp_password' => 'SMTP Şifresi',
    'smtp_encryption' => 'Şifreleme',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'Yok',
    'admin_notifications' => 'Yönetici Bildirimleri',
    'admin_email' => 'Yönetici Bildirim E-postası',
    'admin_email_help' => 'Yönetici bildirimlerini alacak e-posta adresi. Boşsa, giriş yapan yöneticinin e-postası kullanılır.',
    'notify_user_registered' => 'Yeni kullanıcı kaydı',
    'notify_subscription_created' => 'Yeni abonelik oluşturuldu',
    'notify_subscription_cancelled' => 'Abonelik iptal edildi',
    'notify_payment_received' => 'Ödeme alındı',
    'notify_payment_failed' => 'Ödeme başarısız oldu',
    'notify_build_started' => 'Derleme başladı',
    'notify_build_completed' => 'Derleme tamamlandı',
    'notify_build_failed' => 'Derleme başarısız oldu',
    'test_email' => 'Test E-postası',
    'send_test_email' => 'Test E-postası Gönder',
    'sending' => 'Gönderiliyor...',
    'mail_from_name' => 'Gönderen Adı',
    'mail_from_address' => 'Gönderen Adresi',
    'php_mail_info' => 'PHP Mail, sunucunuzun yerleşik e-posta yapılandırmasını (sendmail/postfix) kullanır. Bu panelde ek kurulum gerekmez.',
    'php_mail_switch_warning' => 'Not: Bazı barındırma sağlayıcıları PHP\'nin mail() işlevini devre dışı bırakır. E-postalar gönderilemezse, SMTP\'ye geçin.',
    'admin_notifications_subtitle' => 'Yönetici ödeme bildirimlerinin nereye gönderileceğini yapılandırın',
    'admin_email_description' => 'Yönetici bildirimlerini alacak e-posta adresi. Test e-postaları için de kullanılır.',
    'notification_events' => 'Bildirim Olayları',
    'notification_events_description' => 'Hangi olayların yönetici bildirimi tetikleyeceğini seçin',
    'event_subscription_activated' => 'Abonelik Etkinleştirildi',
    'event_payment_completed' => 'Ödeme Tamamlandı',
    'event_payment_failed' => 'Ödeme Başarısız',
    'event_subscription_cancelled' => 'Abonelik İptal Edildi',
    'event_subscription_expired' => 'Abonelik Süresi Doldu',
    'event_bank_transfer_pending' => 'Banka Havalesi Beklemede',
    'event_user_registered' => 'Kullanıcı Kaydı',
    'event_build_completed' => 'Derleme Tamamlandı',
    'event_build_failed' => 'Derleme Başarısız',

    // Social Login Settings
    'auth_settings_title' => 'Kimlik Doğrulama Ayarları',
    'auth_settings_subtitle' => 'Kayıt ve sosyal giriş seçeneklerini yapılandırın',
    'enable_registration' => 'Kayıt Etkinleştir',
    'enable_registration_description' => 'Yeni kullanıcıların hesap oluşturmasına izin ver',
    'require_email_verification' => 'E-posta Doğrulaması Gerektir',
    'require_email_verification_description' => 'Devre dışı bırakıldığında, yeni kayıtlar otomatik olarak doğrulanır',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Kimlik doğrulama formlarını botlardan koruyun',
    'recaptcha_site_key' => 'Site Anahtarı',
    'recaptcha_site_key_placeholder' => 'reCAPTCHA v3 Site Anahtarınız',
    'recaptcha_secret_key' => 'Gizli Anahtar',
    'recaptcha_secret_key_placeholder' => 'reCAPTCHA v3 Gizli Anahtarınız',
    'leave_blank_keep_current' => 'Mevcut değeri korumak için boş bırakın',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'İstemci ID',
    'client_id_placeholder' => ':provider İstemci ID\'niz',
    'client_secret' => 'İstemci Gizli Anahtarı',
    'client_secret_placeholder' => ':provider İstemci Gizli Anahtarınız',
    'app_id' => 'Uygulama ID',
    'app_id_placeholder' => ':provider Uygulama ID\'niz',
    'app_secret' => 'Uygulama Gizli Anahtarı',
    'app_secret_placeholder' => ':provider Uygulama Gizli Anahtarınız',
    'callback_url' => 'Geri Dönüş URL\'si',
    'oauth_help' => ':provider Geliştirici Konsolunda OAuth kimlik bilgilerini oluşturun. Yukarıdaki geri dönüş URL\'sini kullanın.',
    'test_connection' => 'Bağlantıyı Test Et',
    'testing' => 'Test ediliyor...',
    'configure_oauth' => ':provider OAuth kimlik bilgilerini yapılandırın',
    'add_url_to_console' => 'Bu URL\'yi :provider\'ınıza ekleyin',
    'your_provider_key' => 'Sizin :provider :type',
    'recaptcha_help' => ':link adresinden anahtarlarınızı alın. reCAPTCHA v3 seçtiğinizden emin olun.',
    'recaptcha_console' => 'Google reCAPTCHA Yönetici Konsolu',
    'get_api_key_from' => ':link adresinden API anahtarınızı alın',

    // General Settings
    'general_settings_title' => 'Genel Ayarlar',
    'general_settings_subtitle' => 'Site bilgilerinizi ve markalamanızı güncelleyin',
    'site_name_label' => 'Site Adı',
    'site_description_label' => 'Site Açıklaması',
    'site_description_placeholder' => 'Meta açıklama ve SEO için kullanılır',
    'site_tagline_label' => 'Site Sloganı',
    'site_tagline_placeholder' => 'Logonun altında gösterilen kısa slogan',
    'site_tagline_help' => 'Kenar çubuğu ve giriş sayfalarında logonun altında görüntülenir',
    'purchase_code_label' => 'Satın Alma Kodu',
    'purchase_code_help' => 'Bu kurulum için lisans veya satın alma kodunuz (isteğe bağlı)',
    'logo_light' => 'Logo (Açık Mod)',
    'logo_dark_label' => 'Logo (Koyu Mod)',
    'delete_logo' => 'Logoyu Sil',
    'delete_dark_logo' => 'Koyu Logoyu Sil',
    'delete_favicon' => 'Favicon\'u Sil',
    'logo_help' => 'Önerilen: 200x50px (yatay) veya 50x50px (kare). Şeffaf arka planlı PNG, JPG, SVG. Maks 2MB.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Önerilen: 32x32px veya 16x16px. PNG, ICO veya SVG. Maks 1MB.',
    'default_theme_label' => 'Varsayılan Renk Teması',
    'theme_system' => 'Sistem (Kullanıcının cihaz tercihini takip et)',
    'theme_light' => 'Açık',
    'theme_dark' => 'Koyu',
    'theme_help' => 'Yeni ziyaretçiler için varsayılan tema. Kullanıcılar bunu ayarlarından değiştirebilir.',
    'currency_label' => 'Sistem Para Birimi',
    'currency_help' => 'Tüm fiyatlandırma ve ödemeler için kullanılan para birimi. Bu, hangi ödeme ağ geçitlerinin kullanılabileceğini belirler.',
    'landing_page_toggle' => 'Herkese Açık Açılış Sayfasını Etkinleştir',
    'landing_page_help' => 'Devre dışı bırakıldığında, ana URL\'ye (/) erişen ziyaretçiler giriş sayfasına yönlendirilir',

    // Plan Configuration Settings
    'plan_config_title' => 'Plan Yapılandırması',
    'plan_config_subtitle' => 'Yeni kullanıcılar için varsayılan plan ayarlarını yapılandırın',
    'default_plan_label' => 'Varsayılan Plan',
    'default_plan_none' => 'Yok (abonelik gerekli)',
    'default_plan_help' => 'Kayıt sırasında yeni kullanıcılara atanan plan. Plan seçilmezse, kullanıcıların özelliklere erişmek için abone olması gerekir.',

    // AI Settings
    'ai_settings_title' => 'Yapay Zeka Sohbet Asistanı',
    'ai_settings_subtitle' => 'Yapay zeka destekli uygulama oluşturma asistanını yapılandırın',
    'enable_ai' => 'Yapay Zeka Sohbet Asistanını Etkinleştir',
    'enable_ai_description' => 'Kullanıcıların yapay zeka konuşması ile uygulama oluşturmasına ve yapılandırmasına izin ver',
    'enable_streaming' => 'Akış Yanıtlarını Etkinleştir',
    'enable_streaming_description' => 'Daha etkileşimli bir deneyim için yapay zeka yanıtlarını kelime kelime akıt',
    'streaming_warning' => 'Tüm paylaşımlı barındırma ortamlarında çalışmayabilir',
    'ai_provider' => 'Yapay Zeka Sağlayıcı',
    'ai_provider_help' => 'OpenAI (GPT-4.1) veya Anthropic (Claude) arasında seçin',
    'api_key' => 'API Anahtarı',
    'enter_api_key' => 'API anahtarınızı girin',
    'openai_console' => 'OpenAI konsolu',
    'anthropic_console' => 'Anthropic konsolu',
    'api_key_help' => ':provider adresinden API anahtarınızı alın',
    'advanced_settings' => 'Gelişmiş Ayarlar',
    'ai_model' => 'Yapay Zeka Modeli',
    'ai_model_help' => 'Sohbet yanıtları için kullanılacak yapay zeka modelini seçin',
    'temperature' => 'Sıcaklık',
    'temperature_help' => 'Rastgeleliği kontrol eder. Düşük = daha odaklı, Yüksek = daha yaratıcı',
    'max_tokens' => 'Maksimum Yanıt Token\'ı',
    'max_tokens_help' => 'Yapay zeka yanıtı başına maksimum token. Daha yüksek değerler = daha uzun yanıtlar ama daha fazla maliyet',
    'auto_summarization' => 'Otomatik Özetleme',
    'enable_summarization' => 'Otomatik Özetlemeyi Etkinleştir',
    'summarization_help' => 'Uzun konuşmalarda token kullanımını azaltmak için eski mesajları otomatik olarak özetle',
    'summarization_threshold' => 'Özetleme Eşiği',
    'summarization_threshold_help' => 'Otomatik özetleme tetiklenmeden önceki mesaj sayısı',
    'summarization_keep_recent' => 'Son Mesajları Sakla',
    'summarization_keep_recent_help' => 'Saklanacak son mesaj sayısı',
    'summarization_max_length' => 'Maksimum Özet Uzunluğu',
    'summarization_max_length_help' => 'Özet için maksimum karakter',
    'chat_widget' => 'Sohbet Widget\'ı',
    'widget_position' => 'Widget Konumu',
    'position_bottom_right' => 'Sağ Alt',
    'position_bottom_left' => 'Sol Alt',
    'position_top_right' => 'Sağ Üst',
    'position_top_left' => 'Sol Üst',
    'position_help' => 'Yapay zeka sohbet widget\'ının uygulama düzenleyici sayfasında nerede görüneceği',

    // GDPR Settings
    'gdpr_settings_title' => 'GDPR Ayarları',
    'gdpr_settings_subtitle' => 'GDPR uyumluluğu ve gizlilik ayarlarını yapılandırın',
    'enable_cookie_consent' => 'Çerez Onay Bannerını Etkinleştir',
    'enable_data_export' => 'Veri Dışa Aktarmayı Etkinleştir',
    'enable_account_deletion' => 'Hesap Silmeyi Etkinleştir',
    'deletion_grace_period' => 'Hesap Silme Bekleme Süresi (gün)',
    'audit_log_retention' => 'Denetim Kaydı Saklama (gün)',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize Ayarları',
    'appetize_settings_subtitle' => 'Canlı uygulama önizlemeleri için Appetize.io\'yu yapılandırın',
    'appetize_api_token' => 'Appetize API Token',
    'appetize_api_token_help' => 'Appetize.io kontrol panelinizden API token\'ınızı alın',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Silmek istediğinizden emin misiniz',
    'delete_builder_confirm' => 'Silmek istediğinizden emin misiniz',
    'delete_plan_confirm' => 'Silmek istediğinizden emin misiniz',
    'delete_plan_confirm_suffix' => 'planını?',
    'delete_language_confirm' => 'Silmek istediğinizden emin misiniz',
    'delete_language_note' => 'Bu işlem geri alınamaz. Çeviri dosyaları veri güvenliği için saklanacaktır.',
    'uninstall_plugin' => 'Eklentiyi Kaldır',
    'uninstall_plugin_confirm' => 'Kaldırmak istediğinizden emin misiniz',
    'cancel_subscription_confirm' => 'Aboneliği iptal etmek istediğinizden emin misiniz',
    'reset_email_template' => 'E-posta Şablonunu Sıfırla',
    'reset_template_confirm' => 'Sıfırlamak istediğinizden emin misiniz',
    'reset_template_confirm_suffix' => 'şablonunu varsayılan içeriğine?',
    'reset_template_warning' => 'Yaptığınız tüm özelleştirmeler kaybolacak.',
    'disabled_in_demo' => 'Demo modunda devre dışı',

    // Plugin Upload Modal
    'plugin_file' => 'Eklenti Dosyası',
    'plugin_file_help' => 'ZIP dosyası (MAKS. 10MB)',
    'installing_plugin' => 'Eklenti yükleniyor...',
    'installing' => 'Yükleniyor...',

    // Plugin Config Modal
    'configure_plugin_title' => ':name Yapılandır',
    'no_config_required' => 'Yapılandırma Gerekli Değil',
    'no_config_required_desc' => 'Bu eklenti herhangi bir yapılandırma gerektirmiyor.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io Entegrasyonu',
    'appetize_integration_subtitle' => 'Canlı uygulama önizleme işlevselliğini yapılandırın',
    'enable_appetize_integration' => 'Appetize.io Entegrasyonunu Etkinleştir',
    'enable_appetize_description' => 'Pro/Kurumsal planlı kullanıcıların uygulamaları tarayıcıda önizlemesine izin ver',
    'appetize_api_token_placeholder' => 'Appetize.io API token\'ınızı girin',
    'appetize_api_token_link' => 'API token\'ınızı şuradan alın',
    'auto_upload_builds' => 'Derlemeleri Appetize\'a otomatik yükle',
    'auto_upload_description' => 'Başarılı derlemeleri anında önizleme için otomatik olarak yükle',
    'preview_retention_days' => 'Önizleme Saklama (Gün)',
    'preview_retention_help' => 'Maliyetleri azaltmak için eski önizlemeleri bu kadar gün sonra sil (1-30 gün)',
    'session_timeout_seconds' => 'Oturum Zaman Aşımı (Saniye)',
    'session_timeout_help' => 'Oturum sona ermeden önce hareketsizlik süresi',
    'seconds_30' => '30 saniye',
    'minute_1' => '1 dakika',
    'minutes_2' => '2 dakika',
    'minutes_3' => '3 dakika',
    'minutes_5' => '5 dakika',
    'minutes_10' => '10 dakika',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'GDPR ve Gizlilik Ayarları',
    'gdpr_privacy_settings_subtitle' => 'Veri koruma ve gizlilik uyumluluğunu yapılandırın',
    'feature_toggles' => 'Özellik Anahtarları',
    'cookie_consent_banner' => 'Çerez Onay Bannerı',
    'cookie_consent_description' => 'Yeni ziyaretçilere çerez onay bannerı göster',
    'user_data_export' => 'Kullanıcı Veri Dışa Aktarma',
    'user_data_export_description' => 'Kullanıcıların verilerinin bir kopyasını talep etmesine izin ver',
    'user_account_deletion' => 'Kullanıcı Hesap Silme',
    'user_account_deletion_description' => 'Kullanıcıların hesap silme talep etmesine izin ver',
    'policy_versions' => 'Politika Sürümleri',
    'policy_versions_help' => 'Politika sürümlerini güncellemek kullanıcılar için yeniden onay tetikleyecektir.',
    'privacy_policy' => 'Gizlilik Politikası',
    'terms_of_service' => 'Hizmet Şartları',
    'cookie_policy' => 'Çerez Politikası',
    'data_retention_periods' => 'Veri Saklama Süreleri (Gün)',
    'retention_transactions' => 'İşlemler',
    'retention_transactions_help' => 'Min 365 gün (yasal gereklilik)',
    'retention_inactive_accounts' => 'Aktif Olmayan Hesaplar',
    'retention_expired_builds' => 'Süresi Dolan Derlemeler',
    'retention_audit_logs' => 'Denetim Kayıtları',
    'retention_data_exports' => 'Veri Dışa Aktarmalar',
    'grace_periods_rate_limits' => 'Bekleme Süreleri ve Hız Limitleri',
    'account_deletion_grace_period' => 'Hesap Silme Bekleme Süresi (Gün)',
    'account_deletion_grace_help' => 'Hesabın kalıcı olarak silinmesinden önceki süre',
    'data_export_rate_limit' => 'Veri Dışa Aktarma Hız Limiti (Saat)',
    'data_export_rate_limit_help' => 'Dışa aktarma talepleri arasındaki minimum süre',

    // App/Plan Settings
    'plan_configuration' => 'Plan Yapılandırması',
    'plan_configuration_subtitle' => 'Yeni kullanıcılar için varsayılan plan ayarlarını yapılandırın',
    'default_plan_option_none' => 'Yok (abonelik gerekli)',
    'default_plan_description' => 'Yeni kullanıcılara atanan plan. Kullanımdan önce abonelik gerektirmek için "Yok" seçin.',

    // Overview Stats
    'overview_subtitle' => 'Sistem genelinde istatistikler ve yönetim metrikleri',
    'date_range_today' => 'Bugün',
    'date_range_week' => 'Hafta',
    'date_range_month' => 'Ay',
    'date_range_year' => 'Yıl',
    'date_range_all' => 'Tüm Zamanlar',
    'auto_refresh' => 'Otomatik Yenileme',
    'total_system_users' => 'Toplam Sistem Kullanıcıları',
    'active_subscriptions' => 'Aktif Abonelikler',
    'revenue_label' => ':period Geliri',
    'total_apps' => 'Toplam Uygulamalar',
    'vs_last_month' => 'geçen aya göre',
    'total_builds_stat' => 'Toplam Derlemeler',
    'completed_today' => 'Bugün Tamamlanan',
    'build_success_rate' => 'Derleme Başarı Oranı',
    'pending_queue' => 'Bekleyen Kuyruk',
    'total_transactions' => 'Toplam İşlemler',
    'active_plans' => 'Aktif Planlar',
    'active_builders' => 'Aktif Derleyiciler',
    'revenue_trends' => 'Gelir Trendleri (12 Ay)',
    'build_activity' => 'Derleme Aktivitesi (Son 30 Gün)',
    'revenue_by_gateway' => 'Ödeme Ağ Geçidine Göre Gelir',
    'no_revenue_data' => 'Henüz gelir verisi yok',
    'total_revenue' => 'Toplam Gelir',
    'platform_distribution' => 'Platform Dağılımı',
    'no_apps_created' => 'Henüz uygulama oluşturulmadı',
    'pending_payments' => 'Bekleyen Ödemeler',
    'active_users_7d' => 'Aktif Kullanıcılar (7g)',
    'notifications_today' => 'Bildirimler (Bugün)',
    'build_performance_by_platform' => 'Platforma Göre Derleme Performansı',
    'platform' => 'Platform',
    'completed' => 'Tamamlandı',
    'failed' => 'Başarısız',
    'success_rate' => 'Başarı Oranı',
    'avg_duration' => 'Ort. Süre',
    'revenue_label_short' => 'Gelir',
    'builds_label' => 'Derlemeler',
    'recent_user_registrations' => 'Son Kullanıcı Kayıtları',
    'no_users_yet' => 'Henüz kullanıcı yok',
    'recent_builds' => 'Son Derlemeler',
    'no_builds_yet' => 'Henüz derleme yok',
    'recent_transactions' => 'Son İşlemler',
    'no_transactions_yet' => 'Henüz işlem yok',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Görevler',
    'cronjobs_tab_execution_logs' => 'Çalışma Kayıtları',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API Kimlik Bilgileri',
        'webhook_configuration' => 'Webhook Yapılandırması',
        'webhook_url' => 'Webhook URL\'si',
        'copy' => 'Kopyala',
        'copied' => 'Kopyalandı!',
        'copy_failed' => 'Kopyalama başarısız. Lütfen URL\'yi manuel olarak seçin ve kopyalayın.',
        'required_webhook_events' => 'Gerekli Webhook Olayları',
        'features' => 'Özellikler',
        'supported_features' => 'Desteklenen Özellikler',
        'secret_key' => 'Gizli Anahtar',
        'webhook_secret' => 'Webhook Gizli Anahtarı',
        'webhook_signing_secret' => 'Webhook İmzalama Gizli Anahtarı',
        'optional' => 'İsteğe Bağlı',

        // SSL Warning
        'ssl_warning' => 'Uyarı:',
        'ssl_warning_stripe' => 'Siteniz HTTPS kullanmıyor. Stripe, webhook\'lar ve üretim kullanımı için HTTPS gerektirir.',
        'ssl_warning_paypal' => 'Siteniz HTTPS kullanmıyor. PayPal webhook\'ları güvenli bir HTTPS bağlantısı gerektirir. Yayına almadan önce lütfen SSL/TLS\'yi etkinleştirin.',
        'ssl_warning_paystack' => 'Siteniz HTTPS kullanmıyor. Paystack webhook\'ları güvenli bir HTTPS bağlantısı gerektirir. Yayına almadan önce lütfen SSL/TLS\'yi etkinleştirin.',

        // Stripe
        'stripe' => [
            'get_started' => 'Stripe\'a Başlayın',
            'get_api_keys' => 'API anahtarlarınızı şuradan alın',
            'dashboard_link' => 'Stripe Kontrol Paneli → Geliştiriciler → API Anahtarları',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Test için test anahtarı (sk_test_), üretim için canlı anahtar (sk_live_) kullanın',
            'webhook_url_help' => 'Bu URL\'yi Stripe Kontrol Paneli → Geliştiriciler → Webhook\'lar bölümüne ekleyin',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Stripe Kontrol Panelinde webhook uç noktası oluşturduktan sonra bunu alın',
            'events_help' => 'Webhook uç noktanızı oluştururken bu olayları seçin:',
            'feature_currencies' => 'Küresel olarak 135+ para birimi desteklenir',
            'feature_intervals' => 'Tüm faturalama aralıkları desteklenir',
            'feature_renewal' => 'Otomatik abonelik yenilemesi',
            'feature_customer_management' => 'Müşteri yönetimi',
            'feature_signature_verification' => 'Webhook imza doğrulama',
            'feature_refund' => 'İade işleme',
            'feature_sca' => 'Güçlü Müşteri Kimlik Doğrulaması (SCA) uyumlu',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'İstemci ID',
            'client_id_help' => 'PayPal Geliştirici Kontrol Panelinden alın',
            'client_secret' => 'İstemci Gizli Anahtarı',
            'client_secret_help' => 'Bunu gizli tutun ve asla herkese açık paylaşmayın',
            'sandbox_mode' => 'Sandbox Modu',
            'sandbox_mode_help' => 'PayPal Sandbox ile test için etkinleştirin. Canlı işlemler için devre dışı bırakın.',
            'webhook_url_help' => 'Bu URL\'yi PayPal webhook ayarlarınıza ekleyin',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => 'İmza doğrulama için PayPal Kontrol Panelinden Webhook ID (güvenlik için gerekli)',
            'events_help' => 'PayPal webhook yapılandırmanızda bu olayları etkinleştirdiğinizden emin olun:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Razorpay\'a Başlayın',
            'get_api_keys' => 'API anahtarlarınızı şuradan alın',
            'dashboard_link' => 'Razorpay Kontrol Paneli → Ayarlar → API Anahtarları',
            'key_id' => 'Anahtar ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Test için test anahtarı (rzp_test_), üretim için canlı anahtar (rzp_live_) kullanın',
            'key_secret' => 'Anahtar Gizli',
            'key_secret_help' => 'Bunu gizli tutun ve asla herkese açık paylaşmayın',
            'webhook_url_help' => 'Bu URL\'yi Razorpay Kontrol Paneli → Ayarlar → Webhook\'lar bölümüne ekleyin',
            'webhook_secret_placeholder' => 'Webhook gizli anahtarını girin',
            'webhook_secret_help' => 'Webhook oluşturduktan sonra Razorpay Kontrol Panelinden alın',
            'events_help' => 'Razorpay Kontrol Paneli → Ayarlar → Webhook\'lar bölümünde bu olayları etkinleştirin:',
            'feature_currencies' => '100+ para birimi desteklenir',
            'feature_intervals' => 'Tüm faturalama aralıkları (günlük, haftalık, aylık, yıllık)',
            'feature_payment_methods' => 'UPI, Kartlar, NetBanking, Cüzdanlar, EMI',
            'feature_renewal' => 'Otomatik abonelik yenilemesi',
            'feature_signature_verification' => 'Webhook imza doğrulama',
            'feature_refund' => 'İade işleme',
            'feature_decimal' => 'Üç ondalık para birimi desteği (KWD, BHD vb.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Paystack\'e Başlayın',
            'get_api_keys' => 'API anahtarlarınızı şuradan alın',
            'dashboard_link' => 'Paystack Kontrol Paneli → Ayarlar → API Anahtarları ve Webhook\'lar',
            'secret_key_help' => 'Paystack Kontrol Panelinden alın (test için test anahtarı, üretim için canlı anahtar kullanın)',
            'webhook_url_help' => 'Bu URL\'yi Paystack webhook ayarlarınıza ekleyin',
            'webhook_secret_help' => 'İsteğe bağlı: Webhook imza doğrulama için (üretim için önerilir)',
            'webhook_secret_placeholder' => 'İmza doğrulamayı atlamak için boş bırakın',
            'events_help' => 'Paystack Kontrol Paneli → Ayarlar → API Anahtarları ve Webhook\'lar bölümünde bu olayları etkinleştirin:',
            'feature_currencies' => 'Para birimleri: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Aralıklar: Günlük, Haftalık, Aylık (1, 3, 6 ay), Yıllık',
            'feature_renewal' => 'Otomatik abonelik yenilemesi',
            'feature_signature_verification' => 'Webhook imza doğrulama',
            'feature_interval_limitation' => 'Sınırlı aralık desteği (dokümantasyona bakın)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Crypto.com Pay\'e Başlayın',
            'get_api_keys' => 'API kimlik bilgilerinizi şuradan alın',
            'dashboard_link' => 'Crypto.com Pay Kontrol Paneli',
            'monthly_only_title' => 'Sadece Aylık Aralıklar',
            'monthly_only_description' => 'Crypto.com Pay şu anda sadece aylık faturalama aralıklarını destekliyor. Günlük, haftalık ve yıllık abonelikler desteklenmiyor.',
            'secret_key_placeholder' => 'Crypto.com Pay gizli anahtarınızı girin',
            'secret_key_help' => 'Crypto.com Pay Kontrol Panelinden alın',
            'webhook_url_help' => 'Bu URL\'yi Crypto.com Pay webhook ayarlarınıza ekleyin',
            'webhook_secret_placeholder' => 'Webhook imzalama gizli anahtarını girin',
            'webhook_secret_help' => 'Webhook imza doğrulama için gerekli',
            'events_help' => 'Crypto.com Pay Kontrol Panelinde bu olayları etkinleştirin:',
            'feature_crypto_fiat' => 'Kripto para ve fiat ödemeleri kabul edin',
            'feature_currencies' => '30+ desteklenen para birimi',
            'feature_renewal' => 'Otomatik abonelik yenilemesi',
            'feature_signature_verification' => 'HMAC SHA-256 webhook imza doğrulama',
            'feature_monthly_only' => 'Sadece aylık aralıklar (günlük/haftalık/yıllık desteklenmiyor)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Manuel Onay Gerekli',
            'manual_approval_description' => 'Banka havalesi ödemeleri manuel doğrulama gerektirir. Kullanıcılar ödemeyi başlattıktan sonra aşağıdaki talimatları görecektir. Yöneticiler ödemeleri şuradan onaylamalı veya reddetmelidir',
            'transactions_link' => 'İşlemler',
            'instructions_title' => 'Banka Havalesi Talimatları',
            'instructions_label' => 'Kullanıcılar İçin Talimatlar',
            'instructions_placeholder' => "Banka hesap bilgilerinizi ve havale talimatlarınızı buraya girin...\n\nÖrnek:\n\nBanka Adı: ABC Bankası\nHesap Adı: Şirket Adınız\nHesap Numarası: 123456789\nSwift Kodu: ABCDEFGH\nReferans: [Kullanıcı abonelik ID\'sini görecek]\n\nLütfen ödeme referansında abonelik ID\'nizi ekleyin ve ödeme kanıtını billing@sirketiniz.com adresine e-posta ile gönderin",
            'instructions_help' => 'Bu talimatlar, kullanıcılar bir plan seçtikten sonra gösterilecektir. Banka hesap bilgilerini, referans formatını ve doğrulama adımlarını ekleyin.',
            'workflow_title' => 'Banka Havalesi Ödemeleri Nasıl Çalışır:',
            'workflow_step_1' => 'Kullanıcı bir plan seçer ve ödeme yöntemi olarak Banka Havalesi\'ni seçer',
            'workflow_step_2' => 'Bekleyen bir abonelik ve işlem oluşturulur',
            'workflow_step_3' => 'Kullanıcı yukarıda yapılandırdığınız talimatları görür',
            'workflow_step_4' => 'Kullanıcı banka havalesini manuel olarak tamamlar',
            'workflow_step_5' => 'Yönetici bekleyen ödeme bildirimi alır',
            'workflow_step_6' => 'Yönetici ödemeyi onaylar → abonelik etkinleştirilir ve krediler yenilenir',
            'workflow_step_7' => 'Yönetici ödemeyi reddeder → abonelik ve işlem kaldırılır',
            'feature_currencies' => 'Tüm para birimleri desteklenir',
            'feature_intervals' => 'Tüm faturalama aralıkları desteklenir (günlük, haftalık, aylık, yıllık)',
            'feature_simple_setup' => 'Basit kurulum - API kimlik bilgisi gerekmez',
            'feature_manual_verification' => 'Güvenlik için manuel doğrulama',
            'feature_no_fees' => 'İşlem ücreti veya üçüncü taraf bağımlılığı yok',
            'feature_admin_approval' => 'Her ödeme için yönetici onayı gerektirir',
            'feature_no_renewal' => 'Otomatik abonelik yenilemesi yok',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Sınırsız derleme kredisi',
    'feature_build_credits' => ':count derleme kredisi',
    'feature_all_builders' => 'Tüm aktif derleyicilere erişim',
    'feature_builder_access' => 'Derleyici erişimi',
    'feature_single_builder' => 'Tek derleyiciye erişim',
    'feature_multiple_builders' => ':count derleyiciye erişim',
    'feature_custom_code' => 'Özel CSS/JS ekleme',
    'feature_api_access' => 'API Erişimi',
    'feature_unlimited_hosted_pages' => 'Sınırsız barındırılan sayfa',
    'feature_hosted_pages' => 'Uygulama başına :count barındırılan sayfa',
    'feature_hosted_pages_disabled' => 'Barındırılan sayfalar',
    'feature_unlimited_ai_chat' => 'Sınırsız Yapay Zeka Sohbeti',
    'feature_ai_tokens' => 'Aylık :count AI tokeni',
    'feature_own_ai_key' => 'Kendi AI API anahtarınızı kullanın',
    'feature_ai_chat' => 'Yapay Zeka Sohbet Asistanı',

    // Impersonation
    'impersonate' => 'Taklit Et',
    'impersonate_user' => 'Kullanıcıyı Taklit Et',
    'impersonation_started' => 'Şimdi :name olarak görüntüleniyor',
    'impersonation_stopped' => 'Taklit sona erdi. Tekrar hoş geldiniz!',
    'impersonating_as' => ':name olarak görüntüleniyor',
    'exit_impersonation' => 'Çıkış',
    'return_to_admin' => 'Yöneticiye Dön',
    'not_impersonating' => 'Şu anda herhangi bir kullanıcıyı taklit etmiyorsunuz.',
    'admin_blocked_during_impersonation' => 'Taklit ederken yönetici alanı engellenir. Önce takliti sonlandırın.',
    'impersonation_disabled_demo' => 'Demo modunda taklit devre dışı.',
    'only_admins_can_impersonate' => 'Sadece yöneticiler kullanıcıları taklit edebilir.',
];
