<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Landing Page Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used throughout the landing page
    | components for various messages and labels.
    |
    */

    // Hero Section
    'hero' => [
        'pill_no_coding' => '코딩 필요 없음',
        'pill_5_minute_setup' => '5분 설정',
        'pill_free_tier' => '무료 플랜 제공',
        'headline' => '네이티브 앱을',
        'headline_highlight' => '몇 분 만에 제작',
        'subheadline' => '웹사이트를 모든 플랫폼용 네이티브 앱으로 변환하세요.',
        'subheadline_ai' => 'AI 기반',
        'subheadline_features' => '설정, 커스텀 브랜딩, 푸시 알림, 자동 빌드. 코딩이 필요 없습니다.',
        'cta_get_started' => '무료로 시작하기',
        'cta_view_pricing' => '요금제 보기',
        'stat_developers' => '개발자',
        'stat_apps_built' => '제작된 앱',
        'stat_builds_generated' => '생성된 빌드',
        'rating_text' => '200개 이상의 리뷰에서 4.9/5',
        'phone_app_name' => 'My App',
        'phone_app_type' => '모바일',
        'laptop_title' => 'My App — 대시보드',
    ],

    // Features Section
    'features' => [
        'title' => '멋진 앱을 만드는 데 필요한 모든 것',
        'subtitle' => '코드 한 줄 작성 없이 웹사이트를 전문적인 네이티브 앱으로 변환하는 강력한 기능과 도구입니다.',

        'multi_platform_title' => '멀티 플랫폼 지원',
        'multi_platform_desc' => 'Android, Windows, macOS, Linux용 네이티브 앱을 빌드하세요. 모든 앱 스토어에 배포할 수 있는 플랫폼별 패키지를 생성합니다.',

        'easy_config_title' => '간편한 설정',
        'easy_config_desc' => '코딩 없이 앱 디자인, 내비게이션, 색상, 아이콘, 스플래시 화면 등을 커스터마이징할 수 있는 직관적인 인터페이스입니다.',

        'branding_title' => '완전한 브랜딩 제어',
        'branding_desc' => '앱 아이콘, 스플래시 화면, 테마, 색상을 커스터마이징하고 커스텀 HTML, CSS, JavaScript를 주입하여 완전히 제어하세요.',

        'push_notifications_title' => '푸시 알림',
        'push_notifications_desc' => 'Firebase Cloud Messaging 푸시 알림으로 사용자와 소통하세요. 대시보드에서 직접 앱 사용자에게 타겟팅된 메시지를 보낼 수 있습니다.',

        'build_system_title' => '자동화된 빌드 시스템',
        'build_system_desc' => '클릭 한 번으로 앱을 빌드하세요. 분산 빌드 시스템이 자동으로 플랫폼별 패키지를 생성하여 배포 준비를 완료합니다.',

        'app_signing_title' => '안전한 앱 서명',
        'app_signing_desc' => '서명 인증서를 안전하게 업로드하고 관리하세요. 앱 스토어 배포를 위해 릴리스 빌드에 자신있게 서명하세요.',

        'version_management_title' => '버전 관리',
        'version_management_desc' => '빌드 히스토리로 여러 앱 버전을 관리하세요. 변경 사항 추적, 필요시 롤백, 간편한 버전 관리가 가능합니다.',

        'qr_testing_title' => 'QR 코드 테스트',
        'qr_testing_desc' => 'QR 코드 다운로드로 앱을 즉시 테스트하세요. 앱 스토어에 게시하기 전에 테스터 및 클라이언트와 빌드를 공유하세요.',

        'build_tracking_title' => '빌드 추적',
        'build_tracking_desc' => '상세한 로그로 빌드 상태를 실시간 모니터링하세요. 빌드 시간, 오류를 추적하고 언제든지 이전 버전을 다운로드하세요.',

        'ai_assistant_title' => 'AI 기반 어시스턴트',
        'ai_assistant_desc' => '앱 설정에 대한 지능적인 도움을 받으세요. AI 어시스턴트가 웹사이트를 기반으로 내비게이션, 색상, 설정을 자동으로 구성할 수 있습니다.',

        'api_access_title' => 'API 액세스',
        'api_access_desc' => '종합적인 API를 사용하여 워크플로우에 통합하세요. 앱 생성, 빌드 트리거, 알림 관리를 프로그래밍 방식으로 자동화하세요.',

        'hosted_pages_title' => '호스팅 페이지',
        'hosted_pages_desc' => '앱에 커스텀 HTML 페이지를 직접 삽입하세요. 전체 디자인 제어로 소개 페이지, FAQ, 이용약관 등을 만드세요.',
    ],

    // How It Works Section
    'how_it_works' => [
        'default_title' => '이용 방법',
        'default_subtitle' => '4가지 간단한 단계로 모바일 앱을 제작하세요',

        'step1_title' => 'URL 입력',
        'step1_desc' => '웹사이트 URL을 붙여넣으면 자동으로 분석하여 빠르게 시작할 수 있습니다.',

        'step2_title' => '디자인 커스터마이징',
        'step2_desc' => '색상, 아이콘, 스플래시 화면, 내비게이션 스타일을 선택하세요. 빠른 설정을 위해 AI 지원을 사용하세요.',

        'step3_title' => '앱 빌드',
        'step3_desc' => '분산 시스템으로 원클릭 빌드. 몇 분 만에 네이티브 빌드를 받으세요.',

        'step4_title' => '다운로드 및 게시',
        'step4_desc' => '앱을 다운로드하거나 QR 코드를 스캔하여 테스트하세요. 앱 스토어 게시 준비 완료.',
    ],

    // Pricing Section
    'pricing' => [
        'default_title' => '간단하고 투명한 요금제',
        'default_description' => '필요에 맞는 완벽한 플랜을 선택하세요. 모든 플랜에는 다양한 빌드 크레딧 할당과 함께 핵심 기능이 포함되어 있습니다.',
        'default_popular_badge' => '인기',
        'default_free_text' => '무료',
        'default_no_plans' => '요금제가 곧 공개됩니다. 나중에 다시 확인해 주세요.',
        'start_free' => '무료로 시작',
        'go_pro' => 'Pro 시작',
        'get_enterprise' => 'Enterprise 시작',
    ],

    // Testimonials Section
    'testimonials' => [
        'default_title' => '고객 후기',
        'default_subtitle' => '수천 명의 만족한 개발자와 기업과 함께하세요',
        'anonymous' => '익명',
    ],

    // CTA Section
    'cta' => [
        'title' => '오늘 앱 제작을 시작하세요',
        'subtitle' => ':site_name을 신뢰하는 수천 명의 개발자와 기업과 함께하세요. 신용카드가 필요하지 않습니다.',
        'button' => '무료로 시작하기',
    ],

    // Footer Section
    'footer' => [
        'tagline' => '몇 분 만에 웹사이트에서 네이티브 앱을 제작하세요. 코딩이 필요 없는 전문 앱 빌더입니다.',
        'privacy_policy' => '개인정보 처리방침',
        'terms_of_service' => '이용약관',
        'cookie_policy' => '쿠키 정책',
        'copyright' => '© :year. 모든 권리 보유.',
    ],

    // Social Proof Section
    'social_proof' => [
        'happy_developers' => '만족한 개발자',
        'apps_created' => '생성된 앱',
        'builds_generated' => '생성된 빌드',
    ],

    // Logos Section
    'logos' => [
        'title' => '좋은 회사들과 함께하세요',
    ],

    // Page Titles
    'page_title' => '몇 분 만에 네이티브 모바일 앱 제작',
];
