<?php

return [
    // Page Titles
    'admin_overview' => '管理者概要',
    'overview_title' => '概要',
    'users_title' => 'ユーザー',
    'subscriptions_title' => 'サブスクリプション',
    'transactions_title' => '取引',
    'plans_title' => 'プラン',
    'builders_title' => 'ビルダー',
    'plugins_title' => 'プラグイン',
    'languages_title' => '言語',
    'cronjobs_title' => 'Cronジョブ',
    'email_templates_title' => 'メールテンプレート',
    'audit_logs_title' => '監査ログ',
    'settings_title' => '設定',

    // Page Subtitles
    'users_subtitle' => 'プラットフォームユーザーとアカウントを管理',
    'subscriptions_subtitle' => 'ユーザーのサブスクリプションと請求を監視',
    'transactions_subtitle' => '支払い取引を表示・管理',
    'plans_subtitle' => 'サブスクリプションプランと価格を設定',
    'builders_subtitle' => 'アプリコンパイル用のビルダーを管理',
    'plugins_subtitle' => 'インストール済みプラグインを管理',
    'languages_subtitle' => '利用可能な言語を管理',
    'cronjobs_subtitle' => 'スケジュールされたタスクを監視',
    'email_templates_subtitle' => 'ユーザーに送信されるメール通知をカスタマイズ',
    'cronjobs_subtitle_full' => 'スケジュールされたタスクと自動化を監視',
    'settings_subtitle_full' => 'システム全体の設定と環境設定を構成',
    'search_settings' => '設定を検索...',
    'no_settings_found' => '一致する設定が見つかりません',
    'system_settings' => 'システム設定',
    'clear_search' => '検索をクリア',

    // Settings Sidebar Navigation
    'settings_section_general' => '一般',
    'settings_section_plans' => 'プラン',
    'settings_section_auth' => '認証',
    'settings_section_email' => 'メール',
    'settings_section_privacy' => 'プライバシー',
    'settings_section_preview' => 'プレビュー',
    'settings_section_ai' => 'AIチャット',
    'settings_category_platform' => 'プラットフォーム',
    'settings_category_security' => 'セキュリティ',
    'settings_category_integrations' => '統合',
    'audit_logs_subtitle' => 'GDPRコンプライアンスのためのユーザーアクションとシステムイベントを追跡',
    'no_audit_logs_found' => '監査ログが見つかりません。',
    'search_audit_logs' => 'ユーザー、アクション、IPで検索...',
    'date_time' => '日時',
    'actor' => '実行者',
    'ip_address' => 'IPアドレス',
    'details' => '詳細',
    'view_details' => '詳細を表示',
    'system' => 'システム',
    'clear_filters' => 'フィルターをクリア',
    'to' => '〜',
    'settings_subtitle' => 'システム設定を構成',

    // Users
    'add_user' => 'ユーザーを追加',
    'edit_user' => 'ユーザーを編集',
    'create_user' => 'ユーザーを作成',
    'delete_user' => 'ユーザーを削除',
    'user_info' => 'ユーザー情報',
    'user_details' => 'ユーザー詳細',
    'no_users_found' => 'ユーザーが見つかりません。',
    'search_users' => 'ユーザーを検索...',
    'user_role' => 'ロール',
    'user_plan' => 'プラン',
    'user_joined' => '登録日',
    'email_verified' => 'メール確認済み',
    'mark_email_verified' => 'メールを確認済みにする',
    'role_admin' => '管理者',
    'role_user' => 'ユーザー',
    'leave_blank_password' => '現在のパスワードを維持する場合は空白のまま',

    // Plans
    'add_plan' => 'プランを追加',
    'edit_plan' => 'プランを編集',
    'create_plan' => 'プランを作成',
    'create_new_plan' => '新しいプランを作成',
    'update_plan' => 'プランを更新',
    'delete_plan' => 'プランを削除',
    'no_plans_found' => 'プランが見つかりません。',
    'plan_features' => '機能',
    'plan_price' => '価格',
    'plan_interval' => '請求間隔',
    'monthly' => '月額',
    'yearly' => '年額',
    'default_plan' => 'デフォルトプラン',
    'mark_as_default' => 'デフォルトプランに設定',
    'per_month' => '/月',
    'subscribers' => '登録者',
    'plan_name' => 'プラン名',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => '基本情報',
    'usage_limits' => '使用制限',
    'monthly_build_credits' => '月間ビルドクレジット',
    'unlimited' => '無制限',
    'appetize_preview' => 'Appetizeプレビュー',
    'hosted_pages' => 'ホステッドページ',
    'ai_assistant' => 'AIアシスタント',
    'allow_own_api_keys' => '独自のAPIキーを許可',
    'permissions' => '権限',
    'custom_css_js_injection' => 'カスタムCSS/JS挿入',
    'api_access' => 'APIアクセス',
    'builder_access' => 'ビルダーアクセス',
    'all_builders_allowed' => 'すべてのビルダーを許可',
    'select_builders' => 'ビルダーを選択',
    'builders_selected' => ':count 個のビルダーを選択',
    'allow_all_builders' => 'すべてのビルダーを許可',
    'search_builders_placeholder' => 'ビルダーを検索...',
    'features_pricing_display' => '機能（料金表示用）',
    'feature_name' => '機能名',
    'included' => '含む',
    'not_included' => '含まない',
    'no_features_added' => 'まだ機能が追加されていません。料金ページに表示する機能を追加してください。',

    // Subscriptions
    'add_subscription' => 'サブスクリプションを追加',
    'subscription_details' => 'サブスクリプション詳細',
    'no_subscriptions_found' => 'サブスクリプションが見つかりません。',
    'search_subscriptions' => 'サブスクリプションを検索...',
    'renewal_date' => '更新日',
    'subscription_status' => 'ステータス',
    'change_plan' => 'プランを変更',
    'cancel_subscription' => 'サブスクリプションをキャンセル',
    'next_billing' => '次回請求',
    'no_plan' => 'プランなし',
    'select_user' => 'ユーザーを選択',
    'select_plan' => 'プランを選択',
    'payment_method_placeholder' => '手動、銀行振込など',

    // Transactions
    'transaction_details' => '取引詳細',
    'no_transactions_found' => '取引が見つかりません。',
    'search_transactions' => '取引を検索...',
    'transaction_id' => 'ID',
    'transaction_date' => '日付',
    'transaction_amount' => '金額',
    'payment_method' => '支払い方法',
    'payment_gateway' => '支払いゲートウェイ',
    'transaction_status' => 'ステータス',
    'approve' => '承認',
    'decline' => '却下',
    'confirm_approval' => '承認を確認',
    'confirm_decline' => '却下を確認',
    'approve_payment' => '支払いを承認',
    'decline_payment' => '支払いを却下',
    'approve_bank_transfer_confirm' => 'この銀行振込支払いを承認しますか？これによりユーザーのサブスクリプションが有効になります。',
    'decline_bank_transfer_confirm' => 'この銀行振込支払いを却下しますか？これによりサブスクリプションがキャンセルされ、ユーザーに通知されます。',

    // Builders
    'add_builder' => 'ビルダーを追加',
    'edit_builder' => 'ビルダーを編集',
    'create_builder' => 'ビルダーを作成',
    'delete_builder' => 'ビルダーを削除',
    'no_builders_found' => 'ビルダーが見つかりません。',
    'search_builders' => 'ビルダーを検索...',
    'builder_name' => 'ビルダー名',
    'builder_url' => 'URL',
    'builder_status' => 'ステータス',
    'builder_platform' => 'プラットフォーム',
    'builder_platforms' => 'プラットフォーム',
    'builder_name_placeholder' => '本番ビルダー',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => '生成されたサーバーキー',
    'builder_queue' => 'キュー',
    'current_builds' => '現在のビルド',
    'total_builds' => '合計ビルド',
    'server_url' => 'サーバーURL',
    'port' => 'ポート',
    'server_key' => 'サーバーキー',
    'server_key_help' => 'このビルダーへのAPIリクエストの認証に使用',
    'generate' => '生成',
    'max_queue' => '最大キュー',
    'max_queue_help' => '最大同時ビルド数',
    'build_credit_cost' => 'ビルドクレジットコスト',
    'credit_cost_help' => 'ビルドごとに差し引かれるクレジット',
    'supported_platforms' => 'サポートされるプラットフォーム',
    'select_platforms' => 'プラットフォームを選択',
    'platforms_selected' => ':count 個のプラットフォームを選択',
    'platforms_help' => 'このビルダーがサポートするプラットフォームを1つ以上選択',
    'no_platforms_available' => '利用可能なプラットフォームがありません',
    'no_builders_configured' => 'まだビルダーが設定されていません。',
    'default' => 'デフォルト',
    'locked' => 'ロック済み',
    'from_purchase_code' => '購入コードから',
    'purchase_code_not_set_warning' => '購入コードが設定されていません',
    'purchase_code_not_set_description' => 'デフォルトビルダーには有効な購入コードが必要です。設定 > 一般で設定してください。',
    'server_key_from_purchase_code_help' => 'サーバーキーは購入コードから自動的に設定されます。',

    // Plugins
    'upload_plugin' => 'プラグインをアップロード',
    'configure_plugin' => '設定',
    'delete_plugin' => 'プラグインを削除',
    'no_plugins_found' => 'プラグインが見つかりません。',
    'plugin_name' => '名前',
    'plugin_version' => 'バージョン',
    'plugin_type' => 'タイプ',
    'plugin_status' => 'ステータス',

    // Languages
    'add_language' => '言語を追加',
    'add_new_language' => '新しい言語を追加',
    'edit_language' => '言語を編集',
    'create_language' => '言語を作成',
    'delete_language' => '言語を削除',
    'no_languages_found' => '言語が見つかりません。',
    'cannot_delete_default_language' => 'デフォルトまたはプライマリ言語は削除できません。',
    'default_language_badge' => 'デフォルト',
    'language_name' => '言語名',
    'language_code' => '言語コード',
    'language_code_help' => '2文字のISO 639-1コード（例：en、es、fr）',
    'language_code_from_folder' => '利用可能な翻訳フォルダから選択',
    'language_flag' => 'フラグ',
    'language_flag_help' => '国旗の絵文字',
    'language_flag_auto' => 'フラグは言語コードに基づいて自動設定されます',
    'language_flag_country_code_help' => '2文字の国コード（例：us、gb、es）',
    'language_name_placeholder' => '日本語',
    'language_code_placeholder' => 'ja',
    'language_flag_placeholder' => '🇯🇵',
    'language_status' => 'ステータス',
    'rtl_support' => 'テキスト方向',
    'rtl_enabled' => '右から左（RTL）',
    'rtl_description' => 'アラビア語、ヘブライ語、ペルシャ語、ウルドゥー語などの言語で有効にします',
    'translation_files_created' => '翻訳ファイルは lang/:code/ に作成されます',
    'translation_files_auto_created' => 'この言語を追加する前に、:pathに翻訳ファイルが存在することを確認してください。lang/en/フォルダをコピーし、言語コードに名前を変更して、内容を翻訳してください。',

    // Email Templates
    'edit_template' => 'テンプレートを編集',
    'edit_email_template' => 'メールテンプレートを編集',
    'reset_template' => 'デフォルトにリセット',
    'no_templates_found' => 'テンプレートが見つかりません。',
    'template_subject' => '件名',
    'template_body' => '本文',
    'template_variables' => '利用可能な変数',
    'subject_line' => '件名',
    'email_subject_placeholder' => 'メールの件名...',
    'email_body' => 'メール本文',
    'click_to_insert' => 'クリックしてカーソル位置に挿入',
    'no_variables_available' => 'このテンプレートに利用可能な変数はありません。',
    'quick_tips' => 'クイックヒント',
    'variables_replaced' => '変数は送信時に実際のデータに置き換えられます',
    'toolbar_format_tip' => 'ツールバーを使用してテキストの書式設定、リンクの追加、リストの作成ができます',
    'link_tip' => 'テキストを選択してリンクボタンをクリックすると、クリック可能なリンクを追加できます',

    // Cronjobs
    'no_cronjobs_found' => 'Cronジョブが見つかりません。',
    'no_cron_logs_found' => 'Cronログが見つかりません。',
    'search_logs' => 'ログを検索...',
    'job_name' => 'ジョブ名',
    'job' => 'ジョブ',
    'last_run' => '前回実行',
    'next_run' => '次回実行',
    'run_duration' => '実行時間',
    'started' => '開始',
    'duration' => '所要時間',
    'triggered_by' => 'トリガー元',
    'message' => 'メッセージ',
    'all_jobs' => 'すべてのジョブ',
    'trigger_manually' => '手動トリガー',
    'status_success' => '成功',
    'status_running' => '実行中',

    // Settings
    'general_settings' => '一般設定',
    'email_settings' => 'メール設定',
    'social_login_settings' => 'ソーシャルログイン',
    'appetize_settings' => 'Appetize設定',
    'ai_settings' => 'AI設定',
    'gdpr_settings' => 'GDPR設定',

    // General Settings Fields
    'site_name' => 'サイト名',
    'site_description' => 'サイト説明',
    'site_tagline' => 'サイトタグライン',
    'logo' => 'ロゴ',
    'logo_dark' => 'ダークモードロゴ',
    'favicon' => 'ファビコン',
    'default_theme' => 'デフォルトテーマ',
    'landing_page_enabled' => 'ランディングページを有効化',
    'system_currency' => 'システム通貨',
    'default_language' => 'デフォルト言語',
    'default_language_description' => '新規訪問者および設定のないユーザーのデフォルト言語',

    // Status Labels
    'status_active' => '有効',
    'status_inactive' => '無効',
    'status_pending' => '保留中',
    'status_expired' => '期限切れ',
    'status_cancelled' => 'キャンセル済み',
    'status_completed' => '完了',
    'status_failed' => '失敗',

    // Demo Mode
    'demo_mode_notice' => 'デモモードでは設定を変更できません。',
    'disabled_in_demo' => 'デモモードでは無効',
    'hidden_in_demo' => 'デモモードでは非表示',

    // Plugins
    'plugins_title_full' => 'プラグイン',
    'plugins_subtitle_full' => 'カスタムプラグインで機能を拡張',
    'no_plugins_installed' => 'プラグインがインストールされていません',
    'plugin_activate' => '有効化',
    'plugin_deactivate' => '無効化',
    'plugin_uninstall' => 'アンインストール',
    'plugin_author' => '作者: :author',

    // Languages
    'languages_title_full' => '言語',
    'languages_subtitle_full' => '言語翻訳とローカライゼーションを管理',

    // Cronjobs
    'cronjobs_title_full' => 'Cronジョブ',
    'cronjobs_tab_jobs' => 'スケジュールジョブ',
    'cronjobs_tab_logs' => '実行ログ',
    'execute_job' => '実行',
    'executing_job' => '実行中...',

    // Email Settings
    'email_config_title' => 'メール設定',
    'email_config_subtitle' => 'メール設定とSMTPサーバーを構成',
    'mail_driver' => 'メールドライバー',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mailはサーバーの組み込みメール設定を使用します。シンプルですが、一部のサーバーでは配信に問題がある場合があります。',
    'php_mail_warning' => '注意: 一部のホスティングプロバイダーはPHPのmail()関数を無効にしています。メールが送信されない場合は、SMTPへの切り替えを検討してください。',
    'smtp_config' => 'SMTPサーバー設定',
    'smtp_host' => 'SMTPホスト',
    'smtp_port' => 'SMTPポート',
    'smtp_username' => 'SMTPユーザー名',
    'smtp_password' => 'SMTPパスワード',
    'smtp_encryption' => '暗号化',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'なし',
    'admin_notifications' => '管理者通知',
    'admin_email' => '管理者通知メール',
    'admin_email_help' => '管理者通知を受信するメールアドレス。空の場合、ログイン中の管理者のメールが使用されます。',
    'notify_user_registered' => '新規ユーザー登録',
    'notify_subscription_created' => '新規サブスクリプション作成',
    'notify_subscription_cancelled' => 'サブスクリプションキャンセル',
    'notify_payment_received' => '支払い受領',
    'notify_payment_failed' => '支払い失敗',
    'notify_build_started' => 'ビルド開始',
    'notify_build_completed' => 'ビルド完了',
    'notify_build_failed' => 'ビルド失敗',
    'test_email' => 'テストメール',
    'send_test_email' => 'テストメールを送信',
    'sending' => '送信中...',
    'mail_from_name' => '送信者名',
    'mail_from_address' => '送信元メールアドレス',
    'php_mail_info' => 'PHP Mailはサーバーの組み込みメール設定（sendmail/postfix）を使用します。このパネルで追加の設定は不要です。',
    'php_mail_switch_warning' => '注意: 一部のホスティングプロバイダーはPHPのmail()関数を無効にしています。メール送信に失敗する場合は、SMTPに切り替えてください。',
    'admin_notifications_subtitle' => '管理者支払い通知の送信先を設定',
    'admin_email_description' => '管理者通知を受信するメールアドレス。テストメールにも使用されます。',
    'notification_events' => '通知イベント',
    'notification_events_description' => '管理者通知をトリガーするイベントを選択',
    'event_subscription_activated' => 'サブスクリプション有効化',
    'event_payment_completed' => '支払い完了',
    'event_payment_failed' => '支払い失敗',
    'event_subscription_cancelled' => 'サブスクリプションキャンセル',
    'event_subscription_expired' => 'サブスクリプション期限切れ',
    'event_bank_transfer_pending' => '銀行振込保留中',
    'event_user_registered' => 'ユーザー登録',
    'event_build_completed' => 'ビルド完了',
    'event_build_failed' => 'ビルド失敗',

    // Social Login Settings
    'auth_settings_title' => '認証設定',
    'auth_settings_subtitle' => '登録とソーシャルログインオプションを構成',
    'enable_registration' => '登録を有効化',
    'enable_registration_description' => '新規ユーザーのアカウント登録を許可',
    'require_email_verification' => 'メール確認を必須にする',
    'require_email_verification_description' => '無効にすると、新規登録は自動的に確認済みになります',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'ボットから認証フォームを保護',
    'recaptcha_site_key' => 'サイトキー',
    'recaptcha_site_key_placeholder' => 'reCAPTCHA v3サイトキー',
    'recaptcha_secret_key' => 'シークレットキー',
    'recaptcha_secret_key_placeholder' => 'reCAPTCHA v3シークレットキー',
    'leave_blank_keep_current' => '現在の値を維持する場合は空白のまま',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'クライアントID',
    'client_id_placeholder' => ':providerクライアントID',
    'client_secret' => 'クライアントシークレット',
    'client_secret_placeholder' => ':providerクライアントシークレット',
    'app_id' => 'アプリID',
    'app_id_placeholder' => ':providerアプリID',
    'app_secret' => 'アプリシークレット',
    'app_secret_placeholder' => ':providerアプリシークレット',
    'callback_url' => 'コールバックURL',
    'oauth_help' => ':provider Developer ConsoleでOAuth認証情報を作成してください。上記のコールバックURLを使用してください。',
    'test_connection' => '接続をテスト',
    'testing' => 'テスト中...',
    'configure_oauth' => ':provider OAuth認証情報を設定',
    'add_url_to_console' => 'このURLを:providerに追加',
    'leave_blank_keep_current' => '現在の値を維持する場合は空白のまま',
    'your_provider_key' => ':provider :type',
    'recaptcha_help' => ':linkからキーを取得してください。reCAPTCHA v3を選択してください。',
    'recaptcha_console' => 'Google reCAPTCHA管理コンソール',
    'get_api_key_from' => ':linkからAPIキーを取得',

    // General Settings
    'general_settings_title' => '一般設定',
    'general_settings_subtitle' => 'サイト情報とブランディングを更新',
    'site_name_label' => 'サイト名',
    'site_description_label' => 'サイト説明',
    'site_description_placeholder' => 'メタ説明とSEOに使用',
    'site_tagline_label' => 'サイトタグライン',
    'site_tagline_placeholder' => 'ロゴの下に表示される短いタグライン',
    'site_tagline_help' => 'サイドバーとログインページのロゴの下に表示',
    'purchase_code_label' => '購入コード',
    'purchase_code_help' => 'このインストールのライセンスまたは購入コード（任意）',
    'logo_light' => 'ロゴ（ライトモード）',
    'logo_dark_label' => 'ロゴ（ダークモード）',
    'delete_logo' => 'ロゴを削除',
    'delete_dark_logo' => 'ダークロゴを削除',
    'delete_favicon' => 'ファビコンを削除',
    'logo_help' => '推奨: 200×50px（横長）または50×50px（正方形）。透明背景のPNG、JPG、SVG。最大2MB。',
    'favicon_label' => 'ファビコン',
    'favicon_help' => '推奨: 32×32pxまたは16×16px。PNG、ICO、SVG。最大1MB。',
    'default_theme_label' => 'デフォルトカラーテーマ',
    'theme_system' => 'システム（ユーザーのデバイス設定に従う）',
    'theme_light' => 'ライト',
    'theme_dark' => 'ダーク',
    'theme_help' => '新規訪問者のデフォルトテーマ。ユーザーは設定で変更できます。',
    'currency_label' => 'システム通貨',
    'currency_help' => 'すべての価格と支払いに使用される通貨。これにより利用可能な支払いゲートウェイが決まります。',
    'landing_page_toggle' => '公開ランディングページを有効化',
    'landing_page_help' => '無効にすると、ルートURL (/) にアクセスした訪問者はログインページにリダイレクトされます',

    // Plan Configuration Settings
    'plan_config_title' => 'プラン設定',
    'plan_config_subtitle' => '新規ユーザーのデフォルトプラン設定を構成',
    'default_plan_label' => 'デフォルトプラン',
    'default_plan_none' => 'なし（サブスクリプション必須）',
    'default_plan_help' => '登録時にユーザーに割り当てられるプラン。プランを選択しない場合、ユーザーは機能にアクセスするためにサブスクリプションが必要です。',

    // AI Settings
    'ai_settings_title' => 'AIチャットアシスタント',
    'ai_settings_subtitle' => 'AI搭載のアプリ作成アシスタントを構成',
    'enable_ai' => 'AIチャットアシスタントを有効化',
    'enable_ai_description' => 'ユーザーがAI会話を通じてアプリを作成・設定できるようにする',
    'enable_streaming' => 'ストリーミングレスポンスを有効化',
    'enable_streaming_description' => 'よりインタラクティブな体験のためにAIレスポンスを単語ごとにストリーミング',
    'streaming_warning' => '一部の共有ホスティング環境では動作しない場合があります',
    'ai_provider' => 'AIプロバイダー',
    'ai_provider_help' => 'OpenAI（GPT-4.1）またはAnthropic（Claude）から選択',
    'api_key' => 'APIキー',
    'enter_api_key' => 'APIキーを入力',
    'openai_console' => 'OpenAIコンソール',
    'anthropic_console' => 'Anthropicコンソール',
    'api_key_help' => ':providerからAPIキーを取得',
    'advanced_settings' => '詳細設定',
    'ai_model' => 'AIモデル',
    'ai_model_help' => 'チャットレスポンスに使用するAIモデルを選択',
    'temperature' => '温度',
    'temperature_help' => 'ランダム性を制御。低い = より集中、高い = よりクリエイティブ',
    'max_tokens' => '最大レスポンストークン',
    'max_tokens_help' => 'AIレスポンスごとの最大トークン。高い値 = 長いレスポンスだがコスト増',
    'auto_summarization' => '自動要約',
    'enable_summarization' => '自動要約を有効化',
    'summarization_help' => '長い会話でのトークン使用量を減らすために古いメッセージを自動的に要約',
    'summarization_threshold' => '要約しきい値',
    'summarization_threshold_help' => '自動要約がトリガーされるまでのメッセージ数',
    'summarization_keep_recent' => '最近のメッセージを保持',
    'summarization_keep_recent_help' => '保持する最近のメッセージ数',
    'summarization_max_length' => '最大要約長',
    'summarization_max_length_help' => '要約の最大文字数',
    'chat_widget' => 'チャットウィジェット',
    'widget_position' => 'ウィジェット位置',
    'position_bottom_right' => '右下',
    'position_bottom_left' => '左下',
    'position_top_right' => '右上',
    'position_top_left' => '左上',
    'position_help' => 'アプリエディターページでのAIチャットウィジェットの表示位置',

    // GDPR Settings
    'gdpr_settings_title' => 'GDPR設定',
    'gdpr_settings_subtitle' => 'GDPRコンプライアンスとプライバシー設定を構成',
    'enable_cookie_consent' => 'Cookie同意バナーを有効化',
    'enable_data_export' => 'データエクスポートを有効化',
    'enable_account_deletion' => 'アカウント削除を有効化',
    'deletion_grace_period' => 'アカウント削除猶予期間（日）',
    'audit_log_retention' => '監査ログ保持期間（日）',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize設定',
    'appetize_settings_subtitle' => 'ライブアプリプレビュー用にAppetize.ioを構成',
    'appetize_api_token' => 'Appetize APIトークン',
    'appetize_api_token_help' => 'Appetize.ioダッシュボードからAPIトークンを取得',

    // Delete/Action Modal Messages
    'delete_user_confirm' => '本当に削除しますか',
    'delete_builder_confirm' => '本当に削除しますか',
    'delete_plan_confirm' => '本当に削除しますか',
    'delete_plan_confirm_suffix' => 'プランを？',
    'delete_language_confirm' => '本当に削除しますか',
    'delete_language_note' => 'この操作は元に戻せません。データ安全のため翻訳ファイルは保持されます。',
    'uninstall_plugin' => 'プラグインをアンインストール',
    'uninstall_plugin_confirm' => '本当にアンインストールしますか',
    'cancel_subscription_confirm' => '本当にサブスクリプションをキャンセルしますか',
    'reset_email_template' => 'メールテンプレートをリセット',
    'reset_template_confirm' => '本当にリセットしますか',
    'reset_template_confirm_suffix' => 'をデフォルトコンテンツに？',
    'reset_template_warning' => 'カスタマイズした内容はすべて失われます。',
    'disabled_in_demo' => 'デモモードでは無効',

    // Plugin Upload Modal
    'plugin_file' => 'プラグインファイル',
    'plugin_file_help' => 'ZIPファイル（最大10MB）',
    'installing_plugin' => 'プラグインをインストール中...',
    'installing' => 'インストール中...',

    // Plugin Config Modal
    'configure_plugin_title' => ':nameを設定',
    'no_config_required' => '設定不要',
    'no_config_required_desc' => 'このプラグインは設定を必要としません。',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io統合',
    'appetize_integration_subtitle' => 'ライブアプリプレビュー機能を構成',
    'enable_appetize_integration' => 'Appetize.io統合を有効化',
    'enable_appetize_description' => 'Pro/Enterpriseプランのユーザーがブラウザでアプリをプレビュー可能に',
    'appetize_api_token_placeholder' => 'Appetize.io APIトークンを入力',
    'appetize_api_token_link' => 'APIトークンの取得先：',
    'auto_upload_builds' => 'ビルドを自動的にAppetizeにアップロード',
    'auto_upload_description' => '成功したビルドを即時プレビュー用に自動アップロード',
    'preview_retention_days' => 'プレビュー保持期間（日）',
    'preview_retention_help' => 'コスト削減のため、この日数後に古いプレビューを削除（1〜30日）',
    'session_timeout_seconds' => 'セッションタイムアウト（秒）',
    'session_timeout_help' => 'セッション終了までの非アクティブ時間',
    'seconds_30' => '30秒',
    'minute_1' => '1分',
    'minutes_2' => '2分',
    'minutes_3' => '3分',
    'minutes_5' => '5分',
    'minutes_10' => '10分',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'GDPR＆プライバシー設定',
    'gdpr_privacy_settings_subtitle' => 'データ保護とプライバシーコンプライアンスを構成',
    'feature_toggles' => '機能トグル',
    'cookie_consent_banner' => 'Cookie同意バナー',
    'cookie_consent_description' => '新規訪問者にCookie同意バナーを表示',
    'user_data_export' => 'ユーザーデータエクスポート',
    'user_data_export_description' => 'ユーザーがデータのコピーをリクエスト可能に',
    'user_account_deletion' => 'ユーザーアカウント削除',
    'user_account_deletion_description' => 'ユーザーがアカウント削除をリクエスト可能に',
    'policy_versions' => 'ポリシーバージョン',
    'policy_versions_help' => 'ポリシーバージョンを更新すると、ユーザーに再同意がトリガーされます。',
    'privacy_policy' => 'プライバシーポリシー',
    'terms_of_service' => '利用規約',
    'cookie_policy' => 'Cookieポリシー',
    'data_retention_periods' => 'データ保持期間（日）',
    'retention_transactions' => '取引',
    'retention_transactions_help' => '最低365日（法的要件）',
    'retention_inactive_accounts' => '非アクティブアカウント',
    'retention_expired_builds' => '期限切れビルド',
    'retention_audit_logs' => '監査ログ',
    'retention_data_exports' => 'データエクスポート',
    'grace_periods_rate_limits' => '猶予期間＆レート制限',
    'account_deletion_grace_period' => 'アカウント削除猶予期間（日）',
    'account_deletion_grace_help' => 'アカウントが完全に削除されるまでの時間',
    'data_export_rate_limit' => 'データエクスポートレート制限（時間）',
    'data_export_rate_limit_help' => 'エクスポートリクエスト間の最小時間',

    // App/Plan Settings
    'plan_configuration' => 'プラン設定',
    'plan_configuration_subtitle' => '新規ユーザーのデフォルトプラン設定を構成',
    'default_plan_option_none' => 'なし（サブスクリプション必須）',
    'default_plan_description' => '新規ユーザーに割り当てられるプラン。使用前にサブスクリプションを必須にする場合は「なし」を選択。',

    // Overview Stats
    'overview_subtitle' => 'システム全体の統計と管理メトリクス',
    'date_range_today' => '今日',
    'date_range_week' => '週間',
    'date_range_month' => '月間',
    'date_range_year' => '年間',
    'date_range_all' => '全期間',
    'auto_refresh' => '自動更新',
    'total_system_users' => 'システム総ユーザー数',
    'active_subscriptions' => '有効なサブスクリプション',
    'revenue_label' => ':period収益',
    'total_apps' => '総アプリ数',
    'vs_last_month' => '先月比',
    'total_builds_stat' => '総ビルド数',
    'completed_today' => '本日完了',
    'build_success_rate' => 'ビルド成功率',
    'pending_queue' => '保留キュー',
    'total_transactions' => '総取引数',
    'active_plans' => '有効なプラン',
    'active_builders' => '有効なビルダー',
    'revenue_trends' => '収益トレンド（12ヶ月）',
    'build_activity' => 'ビルドアクティビティ（過去30日）',
    'revenue_by_gateway' => '支払いゲートウェイ別収益',
    'no_revenue_data' => 'まだ収益データがありません',
    'total_revenue' => '総収益',
    'platform_distribution' => 'プラットフォーム分布',
    'no_apps_created' => 'まだアプリが作成されていません',
    'pending_payments' => '保留中の支払い',
    'active_users_7d' => 'アクティブユーザー（7日）',
    'notifications_today' => '今日の通知',
    'build_performance_by_platform' => 'プラットフォーム別ビルドパフォーマンス',
    'platform' => 'プラットフォーム',
    'completed' => '完了',
    'failed' => '失敗',
    'success_rate' => '成功率',
    'avg_duration' => '平均所要時間',
    'revenue_label_short' => '収益',
    'builds_label' => 'ビルド',
    'recent_user_registrations' => '最近のユーザー登録',
    'no_users_yet' => 'まだユーザーがいません',
    'recent_builds' => '最近のビルド',
    'no_builds_yet' => 'まだビルドがありません',
    'recent_transactions' => '最近の取引',
    'no_transactions_yet' => 'まだ取引がありません',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'ジョブ',
    'cronjobs_tab_execution_logs' => '実行ログ',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API認証情報',
        'webhook_configuration' => 'Webhook設定',
        'webhook_url' => 'Webhook URL',
        'copy' => 'コピー',
        'copied' => 'コピーしました！',
        'copy_failed' => 'コピーに失敗しました。URLを手動で選択してコピーしてください。',
        'required_webhook_events' => '必須Webhookイベント',
        'features' => '機能',
        'supported_features' => 'サポートされる機能',
        'secret_key' => 'シークレットキー',
        'webhook_secret' => 'Webhookシークレット',
        'webhook_signing_secret' => 'Webhook署名シークレット',
        'optional' => '任意',

        // SSL Warning
        'ssl_warning' => '警告：',
        'ssl_warning_stripe' => 'サイトがHTTPSを使用していません。StripeはWebhookと本番使用にHTTPSが必要です。',
        'ssl_warning_paypal' => 'サイトがHTTPSを使用していません。PayPal Webhookには安全なHTTPS接続が必要です。本番運用前にSSL/TLSを有効にしてください。',
        'ssl_warning_paystack' => 'サイトがHTTPSを使用していません。Paystack Webhookには安全なHTTPS接続が必要です。本番運用前にSSL/TLSを有効にしてください。',

        // Stripe
        'stripe' => [
            'get_started' => 'Stripeを始める',
            'get_api_keys' => 'APIキーの取得先：',
            'dashboard_link' => 'Stripeダッシュボード → 開発者 → APIキー',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'テスト用はテストキー（sk_test_）、本番用はライブキー（sk_live_）を使用',
            'webhook_url_help' => 'Stripeダッシュボード → 開発者 → WebhooksにこのURLを追加',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'StripeダッシュボードでWebhookエンドポイント作成後に取得',
            'events_help' => 'Webhookエンドポイント作成時にこれらのイベントを選択：',
            'feature_currencies' => '135以上の通貨をグローバルにサポート',
            'feature_intervals' => 'すべての請求間隔をサポート',
            'feature_renewal' => 'サブスクリプション自動更新',
            'feature_customer_management' => '顧客管理',
            'feature_signature_verification' => 'Webhook署名検証',
            'feature_refund' => '返金処理',
            'feature_sca' => '強力な顧客認証（SCA）準拠',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'クライアントID',
            'client_id_help' => 'PayPal Developer Dashboardから取得',
            'client_secret' => 'クライアントシークレット',
            'client_secret_help' => 'このシークレットを安全に保管し、公開しないでください',
            'sandbox_mode' => 'サンドボックスモード',
            'sandbox_mode_help' => 'PayPal Sandboxでのテスト用に有効化。ライブ取引には無効化。',
            'webhook_url_help' => 'PayPal Webhook設定にこのURLを追加',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => '署名検証用のPayPalダッシュボードからのWebhook ID（セキュリティのため必須）',
            'events_help' => 'PayPal Webhook設定でこれらのイベントを有効化してください：',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Razorpayを始める',
            'get_api_keys' => 'APIキーの取得先：',
            'dashboard_link' => 'Razorpayダッシュボード → 設定 → APIキー',
            'key_id' => 'キーID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'テスト用はテストキー（rzp_test_）、本番用はライブキー（rzp_live_）を使用',
            'key_secret' => 'キーシークレット',
            'key_secret_help' => 'このシークレットを安全に保管し、公開しないでください',
            'webhook_url_help' => 'Razorpayダッシュボード → 設定 → WebhooksにこのURLを追加',
            'webhook_secret_placeholder' => 'Webhookシークレットを入力',
            'webhook_secret_help' => 'Razorpayダッシュボードでウェブフック作成後に取得',
            'events_help' => 'Razorpayダッシュボード → 設定 → Webhooksでこれらのイベントを有効化：',
            'feature_currencies' => '100以上の通貨をサポート',
            'feature_intervals' => 'すべての請求間隔（日次、週次、月次、年次）',
            'feature_payment_methods' => 'UPI、カード、ネットバンキング、ウォレット、EMI',
            'feature_renewal' => 'サブスクリプション自動更新',
            'feature_signature_verification' => 'Webhook署名検証',
            'feature_refund' => '返金処理',
            'feature_decimal' => '3桁小数通貨サポート（KWD、BHDなど）',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Paystackを始める',
            'get_api_keys' => 'APIキーの取得先：',
            'dashboard_link' => 'Paystackダッシュボード → 設定 → APIキー＆Webhooks',
            'secret_key_help' => 'Paystackダッシュボードから取得（テスト用はテストキー、本番用はライブキー）',
            'webhook_url_help' => 'Paystack Webhook設定にこのURLを追加',
            'webhook_secret_help' => '任意：Webhook署名検証用（本番では推奨）',
            'webhook_secret_placeholder' => '署名検証をスキップする場合は空白のまま',
            'events_help' => 'Paystackダッシュボード → 設定 → APIキー＆Webhooksでこれらのイベントを有効化：',
            'feature_currencies' => '通貨：NGN、USD、GHS、ZAR、KES',
            'feature_intervals' => '間隔：日次、週次、月次（1、3、6ヶ月）、年次',
            'feature_renewal' => 'サブスクリプション自動更新',
            'feature_signature_verification' => 'Webhook署名検証',
            'feature_interval_limitation' => '間隔サポートに制限あり（ドキュメント参照）',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Crypto.com Payを始める',
            'get_api_keys' => 'API認証情報の取得先：',
            'dashboard_link' => 'Crypto.com Payダッシュボード',
            'monthly_only_title' => '月次間隔のみ',
            'monthly_only_description' => 'Crypto.com Payは現在月次請求間隔のみサポートしています。日次、週次、年次サブスクリプションはサポートされていません。',
            'secret_key_placeholder' => 'Crypto.com Payシークレットキーを入力',
            'secret_key_help' => 'Crypto.com Payダッシュボードから取得',
            'webhook_url_help' => 'Crypto.com Pay Webhook設定にこのURLを追加',
            'webhook_secret_placeholder' => 'Webhook署名シークレットを入力',
            'webhook_secret_help' => 'Webhook署名検証に必須',
            'events_help' => 'Crypto.com Payダッシュボードでこれらのイベントを有効化：',
            'feature_crypto_fiat' => '暗号通貨と法定通貨の支払いを受け付け',
            'feature_currencies' => '30以上の通貨をサポート',
            'feature_renewal' => 'サブスクリプション自動更新',
            'feature_signature_verification' => 'HMAC SHA-256 Webhook署名検証',
            'feature_monthly_only' => '月次間隔のみ（日次/週次/年次はサポートなし）',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => '手動承認が必要',
            'manual_approval_description' => '銀行振込支払いには手動確認が必要です。ユーザーは支払い開始後に以下の手順を表示します。管理者は支払いを承認または却下する必要があります：',
            'transactions_link' => '取引',
            'instructions_title' => '銀行振込手順',
            'instructions_label' => 'ユーザー向け手順',
            'instructions_placeholder' => "ここに銀行口座詳細と振込手順を入力してください...\n\n例：\n\n銀行名：ABC銀行\n口座名義：会社名\n口座番号：123456789\nスイフトコード：ABCDEFGH\n参照：[ユーザーにはサブスクリプションIDが表示されます]\n\n支払い参照にサブスクリプションIDを含め、支払い証明をbilling@yourcompany.comにメールしてください",
            'instructions_help' => 'これらの手順は、ユーザーがプランを選択した後に表示されます。銀行口座詳細、参照形式、確認手順を含めてください。',
            'workflow_title' => '銀行振込支払いの仕組み：',
            'workflow_step_1' => 'ユーザーがプランを選択し、支払い方法として銀行振込を選択',
            'workflow_step_2' => '保留中のサブスクリプションと取引が作成される',
            'workflow_step_3' => 'ユーザーに上記で設定した手順が表示される',
            'workflow_step_4' => 'ユーザーが手動で銀行振込を完了',
            'workflow_step_5' => '管理者に保留中の支払い通知が届く',
            'workflow_step_6' => '管理者が支払いを承認 → サブスクリプションが有効化されクレジットが補充',
            'workflow_step_7' => '管理者が支払いを却下 → サブスクリプションと取引が削除',
            'feature_currencies' => 'すべての通貨をサポート',
            'feature_intervals' => 'すべての請求間隔をサポート（日次、週次、月次、年次）',
            'feature_simple_setup' => 'シンプルなセットアップ - API認証情報不要',
            'feature_manual_verification' => 'セキュリティのための手動確認',
            'feature_no_fees' => '取引手数料やサードパーティ依存なし',
            'feature_admin_approval' => '各支払いに管理者承認が必要',
            'feature_no_renewal' => 'サブスクリプション自動更新なし',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => '無制限のビルドクレジット',
    'feature_build_credits' => ':count ビルドクレジット',
    'feature_all_builders' => 'すべてのアクティブビルダーへのアクセス',
    'feature_builder_access' => 'ビルダーアクセス',
    'feature_single_builder' => '単一ビルダーへのアクセス',
    'feature_multiple_builders' => ':count 個のビルダーへのアクセス',
    'feature_custom_code' => 'カスタムCSS/JS注入',
    'feature_api_access' => 'APIアクセス',
    'feature_unlimited_hosted_pages' => '無制限のホステッドページ',
    'feature_hosted_pages' => 'アプリあたり :count ホステッドページ',
    'feature_hosted_pages_disabled' => 'ホステッドページ',
    'feature_unlimited_ai_chat' => '無制限のAIチャット',
    'feature_ai_tokens' => ':count AIトークン/月',
    'feature_own_ai_key' => '独自のAI APIキーを使用',
    'feature_ai_chat' => 'AIチャットアシスタント',

    // Impersonation
    'impersonate' => '代理ログイン',
    'impersonate_user' => 'ユーザーとして代理ログイン',
    'impersonation_started' => ':name として代理ログイン中',
    'impersonation_stopped' => '代理ログインを終了しました。おかえりなさい！',
    'impersonating_as' => ':name として表示中',
    'exit_impersonation' => '終了',
    'return_to_admin' => '管理者に戻る',
    'not_impersonating' => '現在、どのユーザーも代理ログインしていません。',
    'admin_blocked_during_impersonation' => '代理ログイン中は管理エリアがブロックされています。先に代理ログインを終了してください。',
    'impersonation_disabled_demo' => 'デモモードでは代理ログインは無効です。',
    'only_admins_can_impersonate' => '管理者のみがユーザーとして代理ログインできます。',
];
