<?php

return [
    // Page Titles
    'admin_overview' => 'Ringkasan Admin',
    'overview_title' => 'Ringkasan',
    'users_title' => 'Pengguna',
    'subscriptions_title' => 'Langganan',
    'transactions_title' => 'Transaksi',
    'plans_title' => 'Paket',
    'builders_title' => 'Builder',
    'plugins_title' => 'Plugin',
    'languages_title' => 'Bahasa',
    'cronjobs_title' => 'Cron Job',
    'email_templates_title' => 'Template Email',
    'audit_logs_title' => 'Log Audit',
    'settings_title' => 'Pengaturan',

    // Page Subtitles
    'users_subtitle' => 'Kelola pengguna dan akun platform',
    'subscriptions_subtitle' => 'Pantau langganan dan tagihan pengguna',
    'transactions_subtitle' => 'Lihat dan kelola transaksi pembayaran',
    'plans_subtitle' => 'Konfigurasi paket langganan dan harga',
    'builders_subtitle' => 'Kelola builder untuk kompilasi aplikasi',
    'plugins_subtitle' => 'Kelola plugin yang terinstal',
    'languages_subtitle' => 'Kelola bahasa yang tersedia',
    'cronjobs_subtitle' => 'Pantau tugas terjadwal',
    'email_templates_subtitle' => 'Sesuaikan notifikasi email yang dikirim ke pengguna',
    'cronjobs_subtitle_full' => 'Pantau tugas terjadwal dan otomatisasi',
    'settings_subtitle_full' => 'Konfigurasi pengaturan dan preferensi sistem',
    'search_settings' => 'Cari pengaturan...',
    'no_settings_found' => 'Tidak ada pengaturan ditemukan yang cocok dengan',
    'system_settings' => 'Pengaturan Sistem',
    'clear_search' => 'Bersihkan pencarian',

    // Settings Sidebar Navigation
    'settings_section_general' => 'Umum',
    'settings_section_plans' => 'Paket',
    'settings_section_auth' => 'Autentikasi',
    'settings_section_email' => 'Email',
    'settings_section_privacy' => 'Privasi',
    'settings_section_preview' => 'Pratinjau',
    'settings_section_ai' => 'Chat AI',
    'settings_category_platform' => 'Platform',
    'settings_category_security' => 'Keamanan',
    'settings_category_integrations' => 'Integrasi',
    'audit_logs_subtitle' => 'Lacak aksi pengguna dan event sistem untuk kepatuhan GDPR',
    'no_audit_logs_found' => 'Tidak ada log audit ditemukan.',
    'search_audit_logs' => 'Cari berdasarkan pengguna, aksi, IP...',
    'date_time' => 'Tanggal/Waktu',
    'actor' => 'Aktor',
    'ip_address' => 'Alamat IP',
    'details' => 'Detail',
    'view_details' => 'Lihat Detail',
    'system' => 'Sistem',
    'clear_filters' => 'Bersihkan filter',
    'to' => 'sampai',
    'settings_subtitle' => 'Konfigurasi pengaturan sistem',

    // Users
    'add_user' => 'Tambah Pengguna',
    'edit_user' => 'Ubah Pengguna',
    'create_user' => 'Buat Pengguna',
    'delete_user' => 'Hapus Pengguna',
    'user_info' => 'Info Pengguna',
    'user_details' => 'Detail Pengguna',
    'no_users_found' => 'Tidak ada pengguna ditemukan.',
    'search_users' => 'Cari pengguna...',
    'user_role' => 'Peran',
    'user_plan' => 'Paket',
    'user_joined' => 'Bergabung',
    'email_verified' => 'Email Terverifikasi',
    'mark_email_verified' => 'Tandai email sebagai terverifikasi',
    'role_admin' => 'Admin',
    'role_user' => 'Pengguna',
    'leave_blank_password' => 'Biarkan kosong untuk mempertahankan kata sandi saat ini',

    // Plans
    'add_plan' => 'Tambah Paket',
    'edit_plan' => 'Ubah Paket',
    'create_plan' => 'Buat Paket',
    'create_new_plan' => 'Buat Paket Baru',
    'update_plan' => 'Perbarui Paket',
    'delete_plan' => 'Hapus Paket',
    'no_plans_found' => 'Tidak ada paket ditemukan.',
    'plan_features' => 'Fitur',
    'plan_price' => 'Harga',
    'plan_interval' => 'Interval Tagihan',
    'monthly' => 'Bulanan',
    'yearly' => 'Tahunan',
    'default_plan' => 'Paket Default',
    'mark_as_default' => 'Tandai sebagai paket default',
    'per_month' => '/bulan',
    'subscribers' => 'pelanggan',
    'plan_name' => 'Nama Paket',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Informasi Dasar',
    'usage_limits' => 'Batas Penggunaan',
    'monthly_build_credits' => 'Kredit Build Bulanan',
    'unlimited' => 'Tidak Terbatas',
    'appetize_preview' => 'Pratinjau Appetize',
    'hosted_pages' => 'Halaman Hosted',
    'ai_assistant' => 'Asisten AI',
    'allow_own_api_keys' => 'Izinkan kunci API sendiri',
    'permissions' => 'Izin',
    'custom_css_js_injection' => 'Injeksi CSS/JS Kustom',
    'api_access' => 'Akses API',
    'builder_access' => 'Akses Builder',
    'all_builders_allowed' => 'Semua builder diizinkan',
    'select_builders' => 'Pilih builder',
    'builders_selected' => ':count builder dipilih',
    'allow_all_builders' => 'Izinkan Semua Builder',
    'search_builders_placeholder' => 'Cari builder...',
    'features_pricing_display' => 'Fitur (Tampilan Harga)',
    'feature_name' => 'Nama fitur',
    'included' => 'Termasuk',
    'not_included' => 'Tidak Termasuk',
    'no_features_added' => 'Belum ada fitur ditambahkan. Tambahkan fitur untuk ditampilkan di halaman harga.',

    // Subscriptions
    'add_subscription' => 'Tambah Langganan',
    'subscription_details' => 'Detail Langganan',
    'no_subscriptions_found' => 'Tidak ada langganan ditemukan.',
    'search_subscriptions' => 'Cari langganan...',
    'renewal_date' => 'Tanggal Perpanjangan',
    'subscription_status' => 'Status',
    'change_plan' => 'Ubah Paket',
    'cancel_subscription' => 'Batalkan Langganan',
    'next_billing' => 'Tagihan Berikutnya',
    'no_plan' => 'Tidak Ada Paket',
    'select_user' => 'Pilih pengguna',
    'select_plan' => 'Pilih paket',
    'payment_method_placeholder' => 'Manual, Transfer Bank, dll.',

    // Transactions
    'transaction_details' => 'Detail Transaksi',
    'no_transactions_found' => 'Tidak ada transaksi ditemukan.',
    'search_transactions' => 'Cari transaksi...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Tanggal',
    'transaction_amount' => 'Jumlah',
    'payment_method' => 'Metode Pembayaran',
    'payment_gateway' => 'gateway pembayaran',
    'transaction_status' => 'Status',
    'approve' => 'Setujui',
    'decline' => 'Tolak',
    'confirm_approval' => 'Konfirmasi Persetujuan',
    'confirm_decline' => 'Konfirmasi Penolakan',
    'approve_payment' => 'Setujui Pembayaran',
    'decline_payment' => 'Tolak Pembayaran',
    'approve_bank_transfer_confirm' => 'Apakah Anda yakin ingin menyetujui pembayaran transfer bank ini? Ini akan mengaktifkan langganan pengguna.',
    'decline_bank_transfer_confirm' => 'Apakah Anda yakin ingin menolak pembayaran transfer bank ini? Ini akan membatalkan langganan dan memberi tahu pengguna.',

    // Builders
    'add_builder' => 'Tambah Builder',
    'edit_builder' => 'Ubah Builder',
    'create_builder' => 'Buat Builder',
    'delete_builder' => 'Hapus Builder',
    'no_builders_found' => 'Tidak ada builder ditemukan.',
    'search_builders' => 'Cari builder...',
    'builder_name' => 'Nama Builder',
    'builder_url' => 'URL',
    'builder_status' => 'Status',
    'builder_platform' => 'Platform',
    'builder_platforms' => 'Platform',
    'builder_name_placeholder' => 'Builder Produksi',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Kunci server yang dihasilkan',
    'builder_queue' => 'Antrian',
    'current_builds' => 'Build Saat Ini',
    'total_builds' => 'Total Build',
    'server_url' => 'URL Server',
    'port' => 'Port',
    'server_key' => 'Kunci Server',
    'server_key_help' => 'Digunakan untuk mengautentikasi permintaan API ke builder ini',
    'generate' => 'Hasilkan',
    'max_queue' => 'Antrian Maks',
    'max_queue_help' => 'Build konkuren maksimum',
    'build_credit_cost' => 'Biaya Kredit Build',
    'credit_cost_help' => 'Kredit dipotong per build',
    'supported_platforms' => 'Platform yang Didukung',
    'select_platforms' => 'Pilih platform',
    'platforms_selected' => ':count platform dipilih',
    'platforms_help' => 'Pilih satu atau lebih platform yang didukung builder ini',
    'no_platforms_available' => 'Tidak ada platform tersedia',
    'no_builders_configured' => 'Belum ada builder yang dikonfigurasi.',
    'default' => 'Default',
    'locked' => 'Terkunci',
    'from_purchase_code' => 'Dari kode pembelian',
    'purchase_code_not_set_warning' => 'Kode pembelian belum dikonfigurasi',
    'purchase_code_not_set_description' => 'Builder default memerlukan kode pembelian yang valid. Silakan konfigurasikan di Pengaturan > Umum.',
    'server_key_from_purchase_code_help' => 'Kunci server secara otomatis diatur dari kode pembelian Anda.',

    // Plugins
    'upload_plugin' => 'Unggah Plugin',
    'configure_plugin' => 'Konfigurasi',
    'delete_plugin' => 'Hapus Plugin',
    'no_plugins_found' => 'Tidak ada plugin ditemukan.',
    'plugin_name' => 'Nama',
    'plugin_version' => 'Versi',
    'plugin_type' => 'Tipe',
    'plugin_status' => 'Status',

    // Languages
    'add_language' => 'Tambah Bahasa',
    'add_new_language' => 'Tambah Bahasa Baru',
    'edit_language' => 'Ubah Bahasa',
    'create_language' => 'Buat Bahasa',
    'delete_language' => 'Hapus Bahasa',
    'no_languages_found' => 'Tidak ada bahasa ditemukan.',
    'cannot_delete_default_language' => 'Tidak dapat menghapus bahasa default atau utama.',
    'default_language_badge' => 'Default',
    'language_name' => 'Nama Bahasa',
    'language_code' => 'Kode Bahasa',
    'language_code_help' => 'Kode ISO 639-1 2 huruf (mis., en, es, fr)',
    'language_code_from_folder' => 'Pilih dari folder terjemahan yang tersedia',
    'language_flag' => 'Bendera',
    'language_flag_help' => 'Emoji bendera negara',
    'language_flag_auto' => 'Bendera diatur secara otomatis berdasarkan kode bahasa',
    'language_flag_country_code_help' => 'Kode negara 2 huruf (mis., us, gb, es)',
    'language_name_placeholder' => 'Bahasa Indonesia',
    'language_code_placeholder' => 'id',
    'language_flag_placeholder' => '🇮🇩',
    'language_status' => 'Status',
    'rtl_support' => 'Arah Teks',
    'rtl_enabled' => 'Kanan-ke-Kiri (RTL)',
    'rtl_description' => 'Aktifkan untuk bahasa seperti Arab, Ibrani, Persia, dan Urdu',
    'translation_files_created' => 'File terjemahan akan dibuat di: lang/:code/',
    'translation_files_auto_created' => 'Pastikan file terjemahan ada di :path sebelum menambahkan bahasa ini. Salin folder lang/en/, ubah namanya ke kode bahasa Anda, dan terjemahkan isinya.',

    // Email Templates
    'edit_template' => 'Ubah Template',
    'edit_email_template' => 'Ubah Template Email',
    'reset_template' => 'Kembalikan ke Default',
    'no_templates_found' => 'Tidak ada template ditemukan.',
    'template_subject' => 'Subjek',
    'template_body' => 'Isi',
    'template_variables' => 'Variabel yang Tersedia',
    'subject_line' => 'Baris Subjek',
    'email_subject_placeholder' => 'Subjek email...',
    'email_body' => 'Isi Email',
    'click_to_insert' => 'Klik untuk menyisipkan di posisi kursor',
    'no_variables_available' => 'Tidak ada variabel tersedia untuk template ini.',
    'quick_tips' => 'Tips Cepat',
    'variables_replaced' => 'Variabel diganti dengan data nyata saat dikirim',
    'toolbar_format_tip' => 'Gunakan toolbar untuk memformat teks, menambahkan tautan, dan membuat daftar',
    'link_tip' => 'Pilih teks dan klik tombol tautan untuk menambahkan tautan yang dapat diklik',

    // Cronjobs
    'no_cronjobs_found' => 'Tidak ada cron job ditemukan.',
    'no_cron_logs_found' => 'Tidak ada log cron ditemukan.',
    'search_logs' => 'Cari log...',
    'job_name' => 'Nama Tugas',
    'job' => 'Tugas',
    'last_run' => 'Terakhir Dijalankan',
    'next_run' => 'Berikutnya Dijalankan',
    'run_duration' => 'Durasi',
    'started' => 'Dimulai',
    'duration' => 'Durasi',
    'triggered_by' => 'Dipicu Oleh',
    'message' => 'Pesan',
    'all_jobs' => 'Semua Tugas',
    'trigger_manually' => 'Picu Manual',
    'status_success' => 'Berhasil',
    'status_running' => 'Berjalan',

    // Settings
    'general_settings' => 'Pengaturan Umum',
    'email_settings' => 'Pengaturan Email',
    'social_login_settings' => 'Login Sosial',
    'appetize_settings' => 'Pengaturan Appetize',
    'ai_settings' => 'Pengaturan AI',
    'gdpr_settings' => 'Pengaturan GDPR',

    // General Settings Fields
    'site_name' => 'Nama Situs',
    'site_description' => 'Deskripsi Situs',
    'site_tagline' => 'Tagline Situs',
    'logo' => 'Logo',
    'logo_dark' => 'Logo Mode Gelap',
    'favicon' => 'Favicon',
    'default_theme' => 'Tema Default',
    'landing_page_enabled' => 'Aktifkan Halaman Landing',
    'system_currency' => 'Mata Uang Sistem',
    'default_language' => 'Bahasa Default',
    'default_language_description' => 'Bahasa default untuk pengunjung baru dan pengguna tanpa preferensi',

    // Status Labels
    'status_active' => 'Aktif',
    'status_inactive' => 'Tidak Aktif',
    'status_pending' => 'Menunggu',
    'status_expired' => 'Kedaluwarsa',
    'status_cancelled' => 'Dibatalkan',
    'status_completed' => 'Selesai',
    'status_failed' => 'Gagal',

    // Demo Mode
    'demo_mode_notice' => 'Pengaturan tidak dapat diubah dalam mode demo.',
    'disabled_in_demo' => 'Dinonaktifkan dalam mode demo',
    'hidden_in_demo' => 'Disembunyikan dalam mode demo',

    // Plugins
    'plugins_title_full' => 'Plugin',
    'plugins_subtitle_full' => 'Perluas fungsionalitas dengan plugin kustom',
    'no_plugins_installed' => 'Tidak ada plugin terinstal',
    'plugin_activate' => 'Aktifkan',
    'plugin_deactivate' => 'Nonaktifkan',
    'plugin_uninstall' => 'Hapus Instalasi',
    'plugin_author' => 'oleh :author',

    // Languages
    'languages_title_full' => 'Bahasa',
    'languages_subtitle_full' => 'Kelola terjemahan bahasa dan lokalisasi',

    // Cronjobs
    'cronjobs_title_full' => 'Cron Job',
    'cronjobs_tab_jobs' => 'Tugas Terjadwal',
    'cronjobs_tab_logs' => 'Log Eksekusi',
    'execute_job' => 'Jalankan',
    'executing_job' => 'Menjalankan...',

    // Email Settings
    'email_config_title' => 'Konfigurasi Email',
    'email_config_subtitle' => 'Konfigurasi pengaturan email dan server SMTP',
    'mail_driver' => 'Driver Email',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail menggunakan konfigurasi email bawaan server Anda. Sederhana tetapi mungkin memiliki masalah pengiriman di beberapa server.',
    'php_mail_warning' => 'Catatan: Beberapa penyedia hosting menonaktifkan fungsi mail() PHP. Jika email tidak terkirim, pertimbangkan untuk beralih ke SMTP.',
    'smtp_config' => 'Konfigurasi Server SMTP',
    'smtp_host' => 'Host SMTP',
    'smtp_port' => 'Port SMTP',
    'smtp_username' => 'Username SMTP',
    'smtp_password' => 'Password SMTP',
    'smtp_encryption' => 'Enkripsi',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'Tidak Ada',
    'admin_notifications' => 'Notifikasi Admin',
    'admin_email' => 'Email Notifikasi Admin',
    'admin_email_help' => 'Alamat email untuk menerima notifikasi admin. Jika kosong, email admin yang login akan digunakan.',
    'notify_user_registered' => 'Pengguna baru terdaftar',
    'notify_subscription_created' => 'Langganan baru dibuat',
    'notify_subscription_cancelled' => 'Langganan dibatalkan',
    'notify_payment_received' => 'Pembayaran diterima',
    'notify_payment_failed' => 'Pembayaran gagal',
    'notify_build_started' => 'Build dimulai',
    'notify_build_completed' => 'Build selesai',
    'notify_build_failed' => 'Build gagal',
    'test_email' => 'Email Tes',
    'send_test_email' => 'Kirim Email Tes',
    'sending' => 'Mengirim...',
    'mail_from_name' => 'Nama Pengirim Email',
    'mail_from_address' => 'Alamat Pengirim Email',
    'php_mail_info' => 'PHP Mail menggunakan konfigurasi email bawaan server Anda (sendmail/postfix). Tidak diperlukan pengaturan tambahan di panel ini.',
    'php_mail_switch_warning' => 'Catatan: Beberapa penyedia hosting menonaktifkan fungsi mail() PHP. Jika email gagal terkirim, beralih ke SMTP.',
    'admin_notifications_subtitle' => 'Konfigurasi kemana notifikasi pembayaran admin dikirim',
    'admin_email_description' => 'Alamat email untuk menerima notifikasi admin. Juga digunakan untuk email tes.',
    'notification_events' => 'Event Notifikasi',
    'notification_events_description' => 'Pilih event mana yang harus memicu notifikasi admin',
    'event_subscription_activated' => 'Langganan Diaktifkan',
    'event_payment_completed' => 'Pembayaran Selesai',
    'event_payment_failed' => 'Pembayaran Gagal',
    'event_subscription_cancelled' => 'Langganan Dibatalkan',
    'event_subscription_expired' => 'Langganan Kedaluwarsa',
    'event_bank_transfer_pending' => 'Transfer Bank Tertunda',
    'event_user_registered' => 'Pengguna Terdaftar',
    'event_build_completed' => 'Build Selesai',
    'event_build_failed' => 'Build Gagal',

    // Social Login Settings
    'auth_settings_title' => 'Pengaturan Autentikasi',
    'auth_settings_subtitle' => 'Konfigurasi opsi pendaftaran dan login sosial',
    'enable_registration' => 'Aktifkan Pendaftaran',
    'enable_registration_description' => 'Izinkan pengguna baru untuk mendaftarkan akun',
    'require_email_verification' => 'Wajibkan Verifikasi Email',
    'require_email_verification_description' => 'Jika dinonaktifkan, pendaftaran baru otomatis terverifikasi',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Lindungi formulir autentikasi dari bot',
    'recaptcha_site_key' => 'Site Key',
    'recaptcha_site_key_placeholder' => 'Site Key reCAPTCHA v3 Anda',
    'recaptcha_secret_key' => 'Secret Key',
    'recaptcha_secret_key_placeholder' => 'Secret Key reCAPTCHA v3 Anda',
    'leave_blank_keep_current' => 'Biarkan kosong untuk mempertahankan saat ini',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'Client ID',
    'client_id_placeholder' => 'Client ID :provider Anda',
    'client_secret' => 'Client Secret',
    'client_secret_placeholder' => 'Client Secret :provider Anda',
    'app_id' => 'App ID',
    'app_id_placeholder' => 'App ID :provider Anda',
    'app_secret' => 'App Secret',
    'app_secret_placeholder' => 'App Secret :provider Anda',
    'callback_url' => 'Callback URL',
    'oauth_help' => 'Buat kredensial OAuth di Konsol Developer :provider. Gunakan callback URL di atas.',
    'test_connection' => 'Tes Koneksi',
    'testing' => 'Menguji...',
    'configure_oauth' => 'Konfigurasi kredensial OAuth :provider',
    'add_url_to_console' => 'Tambahkan URL ini ke :provider Anda',
    'your_provider_key' => ':type :provider Anda',
    'recaptcha_help' => 'Dapatkan kunci Anda dari :link. Pastikan untuk memilih reCAPTCHA v3.',
    'recaptcha_console' => 'Konsol Admin Google reCAPTCHA',
    'get_api_key_from' => 'Dapatkan kunci API Anda dari :link',

    // General Settings
    'general_settings_title' => 'Pengaturan Umum',
    'general_settings_subtitle' => 'Perbarui informasi dan branding situs Anda',
    'site_name_label' => 'Nama Situs',
    'site_description_label' => 'Deskripsi Situs',
    'site_description_placeholder' => 'Digunakan untuk deskripsi meta dan SEO',
    'site_tagline_label' => 'Tagline Situs',
    'site_tagline_placeholder' => 'Tagline pendek ditampilkan di bawah logo',
    'site_tagline_help' => 'Ditampilkan di bawah logo di sidebar dan halaman login',
    'purchase_code_label' => 'Kode Pembelian',
    'purchase_code_help' => 'Lisensi atau kode pembelian Anda untuk instalasi ini (opsional)',
    'logo_light' => 'Logo (Mode Terang)',
    'logo_dark_label' => 'Logo (Mode Gelap)',
    'delete_logo' => 'Hapus Logo',
    'delete_dark_logo' => 'Hapus Logo Gelap',
    'delete_favicon' => 'Hapus Favicon',
    'logo_help' => 'Disarankan: 200x50px (horizontal) atau 50x50px (persegi). PNG, JPG, SVG dengan latar belakang transparan. Maks 2MB.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Disarankan: 32x32px atau 16x16px. PNG, ICO, atau SVG. Maks 1MB.',
    'default_theme_label' => 'Tema Warna Default',
    'theme_system' => 'Sistem (Ikuti preferensi perangkat pengguna)',
    'theme_light' => 'Terang',
    'theme_dark' => 'Gelap',
    'theme_help' => 'Tema default untuk pengunjung baru. Pengguna dapat mengubah ini di pengaturan mereka.',
    'currency_label' => 'Mata Uang Sistem',
    'currency_help' => 'Mata uang yang digunakan untuk semua harga dan pembayaran. Ini menentukan gateway pembayaran mana yang tersedia.',
    'landing_page_toggle' => 'Aktifkan Halaman Landing Publik',
    'landing_page_help' => 'Jika dinonaktifkan, pengunjung yang mengakses URL root (/) akan dialihkan ke halaman login',

    // Plan Configuration Settings
    'plan_config_title' => 'Konfigurasi Paket',
    'plan_config_subtitle' => 'Konfigurasi pengaturan paket default untuk pengguna baru',
    'default_plan_label' => 'Paket Default',
    'default_plan_none' => 'Tidak Ada (wajib berlangganan)',
    'default_plan_help' => 'Paket yang ditetapkan ke pengguna baru saat pendaftaran. Jika tidak ada paket yang dipilih, pengguna harus berlangganan untuk mengakses fitur.',

    // AI Settings
    'ai_settings_title' => 'Asisten Chat AI',
    'ai_settings_subtitle' => 'Konfigurasi asisten pembuatan aplikasi berbasis AI',
    'enable_ai' => 'Aktifkan Asisten Chat AI',
    'enable_ai_description' => 'Izinkan pengguna membuat dan mengonfigurasi aplikasi melalui percakapan AI',
    'enable_streaming' => 'Aktifkan Respons Streaming',
    'enable_streaming_description' => 'Stream respons AI kata per kata untuk pengalaman yang lebih interaktif',
    'streaming_warning' => 'Mungkin tidak berfungsi di semua lingkungan shared hosting',
    'ai_provider' => 'Penyedia AI',
    'ai_provider_help' => 'Pilih antara OpenAI (GPT-4.1) atau Anthropic (Claude)',
    'api_key' => 'Kunci API',
    'enter_api_key' => 'Masukkan kunci API Anda',
    'openai_console' => 'konsol OpenAI',
    'anthropic_console' => 'konsol Anthropic',
    'api_key_help' => 'Dapatkan kunci API Anda dari :provider',
    'advanced_settings' => 'Pengaturan Lanjutan',
    'ai_model' => 'Model AI',
    'ai_model_help' => 'Pilih model AI yang digunakan untuk respons chat',
    'temperature' => 'Temperatur',
    'temperature_help' => 'Mengontrol keacakan. Lebih rendah = lebih fokus, Lebih tinggi = lebih kreatif',
    'max_tokens' => 'Token Respons Maks',
    'max_tokens_help' => 'Token maksimum per respons AI. Nilai lebih tinggi = respons lebih panjang tetapi lebih mahal',
    'auto_summarization' => 'Auto-Summarization',
    'enable_summarization' => 'Aktifkan Auto-Summarization',
    'summarization_help' => 'Secara otomatis meringkas pesan lama untuk mengurangi penggunaan token dalam percakapan panjang',
    'summarization_threshold' => 'Ambang Batas Summarization',
    'summarization_threshold_help' => 'Jumlah pesan sebelum auto-summarization dipicu',
    'summarization_keep_recent' => 'Simpan Pesan Terbaru',
    'summarization_keep_recent_help' => 'Jumlah pesan terbaru yang disimpan',
    'summarization_max_length' => 'Panjang Ringkasan Maks',
    'summarization_max_length_help' => 'Karakter maksimum untuk ringkasan',
    'chat_widget' => 'Widget Chat',
    'widget_position' => 'Posisi Widget',
    'position_bottom_right' => 'Kanan Bawah',
    'position_bottom_left' => 'Kiri Bawah',
    'position_top_right' => 'Kanan Atas',
    'position_top_left' => 'Kiri Atas',
    'position_help' => 'Di mana widget chat AI muncul di halaman editor aplikasi',

    // GDPR Settings
    'gdpr_settings_title' => 'Pengaturan GDPR',
    'gdpr_settings_subtitle' => 'Konfigurasi kepatuhan GDPR dan pengaturan privasi',
    'enable_cookie_consent' => 'Aktifkan Banner Persetujuan Cookie',
    'enable_data_export' => 'Aktifkan Ekspor Data',
    'enable_account_deletion' => 'Aktifkan Penghapusan Akun',
    'deletion_grace_period' => 'Masa Tenggang Penghapusan Akun (hari)',
    'audit_log_retention' => 'Retensi Log Audit (hari)',

    // Appetize Settings
    'appetize_settings_title' => 'Pengaturan Appetize',
    'appetize_settings_subtitle' => 'Konfigurasi Appetize.io untuk pratinjau aplikasi langsung',
    'appetize_api_token' => 'Token API Appetize',
    'appetize_api_token_help' => 'Dapatkan token API Anda dari dasbor Appetize.io',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Apakah Anda yakin ingin menghapus',
    'delete_builder_confirm' => 'Apakah Anda yakin ingin menghapus',
    'delete_plan_confirm' => 'Apakah Anda yakin ingin menghapus paket',
    'delete_plan_confirm_suffix' => '?',
    'delete_language_confirm' => 'Apakah Anda yakin ingin menghapus',
    'delete_language_note' => 'Tindakan ini tidak dapat dibatalkan. File terjemahan akan disimpan untuk keamanan data.',
    'uninstall_plugin' => 'Hapus Instalasi Plugin',
    'uninstall_plugin_confirm' => 'Apakah Anda yakin ingin menghapus instalasi',
    'cancel_subscription_confirm' => 'Apakah Anda yakin ingin membatalkan langganan untuk',
    'reset_email_template' => 'Reset Template Email',
    'reset_template_confirm' => 'Apakah Anda yakin ingin mereset',
    'reset_template_confirm_suffix' => 'ke konten defaultnya?',
    'reset_template_warning' => 'Kustomisasi apa pun yang telah Anda buat akan hilang.',
    'disabled_in_demo' => 'Dinonaktifkan dalam mode demo',

    // Plugin Upload Modal
    'plugin_file' => 'File Plugin',
    'plugin_file_help' => 'File ZIP (MAKS. 10MB)',
    'installing_plugin' => 'Menginstal plugin...',
    'installing' => 'Menginstal...',

    // Plugin Config Modal
    'configure_plugin_title' => 'Konfigurasi :name',
    'no_config_required' => 'Tidak Diperlukan Konfigurasi',
    'no_config_required_desc' => 'Plugin ini tidak memerlukan konfigurasi apa pun.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Integrasi Appetize.io',
    'appetize_integration_subtitle' => 'Konfigurasi fungsionalitas pratinjau aplikasi langsung',
    'enable_appetize_integration' => 'Aktifkan Integrasi Appetize.io',
    'enable_appetize_description' => 'Izinkan pengguna dengan paket Pro/Enterprise untuk melihat pratinjau aplikasi di browser',
    'appetize_api_token_placeholder' => 'Masukkan token API Appetize.io Anda',
    'appetize_api_token_link' => 'Dapatkan token API Anda dari',
    'auto_upload_builds' => 'Auto-upload build ke Appetize',
    'auto_upload_description' => 'Secara otomatis mengunggah build yang berhasil untuk pratinjau instan',
    'preview_retention_days' => 'Retensi Pratinjau (Hari)',
    'preview_retention_help' => 'Hapus pratinjau lama setelah sekian hari untuk menghemat biaya (1-30 hari)',
    'session_timeout_seconds' => 'Timeout Sesi (Detik)',
    'session_timeout_help' => 'Timeout ketidakaktifan sebelum sesi berakhir',
    'seconds_30' => '30 detik',
    'minute_1' => '1 menit',
    'minutes_2' => '2 menit',
    'minutes_3' => '3 menit',
    'minutes_5' => '5 menit',
    'minutes_10' => '10 menit',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'Pengaturan GDPR & Privasi',
    'gdpr_privacy_settings_subtitle' => 'Konfigurasi perlindungan data dan kepatuhan privasi',
    'feature_toggles' => 'Toggle Fitur',
    'cookie_consent_banner' => 'Banner Persetujuan Cookie',
    'cookie_consent_description' => 'Tampilkan banner persetujuan cookie kepada pengunjung baru',
    'user_data_export' => 'Ekspor Data Pengguna',
    'user_data_export_description' => 'Izinkan pengguna meminta salinan data mereka',
    'user_account_deletion' => 'Penghapusan Akun Pengguna',
    'user_account_deletion_description' => 'Izinkan pengguna meminta penghapusan akun',
    'policy_versions' => 'Versi Kebijakan',
    'policy_versions_help' => 'Memperbarui versi kebijakan akan memicu persetujuan ulang untuk pengguna.',
    'privacy_policy' => 'Kebijakan Privasi',
    'terms_of_service' => 'Syarat Layanan',
    'cookie_policy' => 'Kebijakan Cookie',
    'data_retention_periods' => 'Periode Retensi Data (Hari)',
    'retention_transactions' => 'Transaksi',
    'retention_transactions_help' => 'Min 365 hari (persyaratan hukum)',
    'retention_inactive_accounts' => 'Akun Tidak Aktif',
    'retention_expired_builds' => 'Build Kedaluwarsa',
    'retention_audit_logs' => 'Log Audit',
    'retention_data_exports' => 'Ekspor Data',
    'grace_periods_rate_limits' => 'Masa Tenggang & Batas Rate',
    'account_deletion_grace_period' => 'Masa Tenggang Penghapusan Akun (Hari)',
    'account_deletion_grace_help' => 'Waktu sebelum akun dihapus secara permanen',
    'data_export_rate_limit' => 'Batas Rate Ekspor Data (Jam)',
    'data_export_rate_limit_help' => 'Waktu minimum antara permintaan ekspor',

    // App/Plan Settings
    'plan_configuration' => 'Konfigurasi Paket',
    'plan_configuration_subtitle' => 'Konfigurasi pengaturan paket default untuk pengguna baru',
    'default_plan_option_none' => 'Tidak Ada (wajib berlangganan)',
    'default_plan_description' => 'Paket yang ditetapkan ke pengguna baru. Pilih "Tidak Ada" untuk mewajibkan langganan sebelum digunakan.',

    // Overview Stats
    'overview_subtitle' => 'Statistik dan metrik administrasi seluruh sistem',
    'date_range_today' => 'Hari Ini',
    'date_range_week' => 'Minggu',
    'date_range_month' => 'Bulan',
    'date_range_year' => 'Tahun',
    'date_range_all' => 'Semua Waktu',
    'auto_refresh' => 'Auto-Refresh',
    'total_system_users' => 'Total Pengguna Sistem',
    'active_subscriptions' => 'Langganan Aktif',
    'revenue_label' => 'Pendapatan :period',
    'total_apps' => 'Total Aplikasi',
    'vs_last_month' => 'vs bulan lalu',
    'total_builds_stat' => 'Total Build',
    'completed_today' => 'Selesai Hari Ini',
    'build_success_rate' => 'Tingkat Keberhasilan Build',
    'pending_queue' => 'Antrian Tertunda',
    'total_transactions' => 'Total Transaksi',
    'active_plans' => 'Paket Aktif',
    'active_builders' => 'Builder Aktif',
    'revenue_trends' => 'Tren Pendapatan (12 Bulan)',
    'build_activity' => 'Aktivitas Build (30 Hari Terakhir)',
    'revenue_by_gateway' => 'Pendapatan per Gateway Pembayaran',
    'no_revenue_data' => 'Belum ada data pendapatan tersedia',
    'total_revenue' => 'Total Pendapatan',
    'platform_distribution' => 'Distribusi Platform',
    'no_apps_created' => 'Belum ada aplikasi dibuat',
    'pending_payments' => 'Pembayaran Tertunda',
    'active_users_7d' => 'Pengguna Aktif (7h)',
    'notifications_today' => 'Notifikasi (Hari Ini)',
    'build_performance_by_platform' => 'Performa Build per Platform',
    'platform' => 'Platform',
    'completed' => 'Selesai',
    'failed' => 'Gagal',
    'success_rate' => 'Tingkat Keberhasilan',
    'avg_duration' => 'Durasi Rata-rata',
    'revenue_label_short' => 'Pendapatan',
    'builds_label' => 'Build',
    'recent_user_registrations' => 'Pendaftaran Pengguna Terbaru',
    'no_users_yet' => 'Belum ada pengguna',
    'recent_builds' => 'Build Terbaru',
    'no_builds_yet' => 'Belum ada build',
    'recent_transactions' => 'Transaksi Terbaru',
    'no_transactions_yet' => 'Belum ada transaksi',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Tugas',
    'cronjobs_tab_execution_logs' => 'Log Eksekusi',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'Kredensial API',
        'webhook_configuration' => 'Konfigurasi Webhook',
        'webhook_url' => 'URL Webhook',
        'copy' => 'Salin',
        'copied' => 'Tersalin!',
        'copy_failed' => 'Gagal menyalin. Silakan pilih dan salin URL secara manual.',
        'required_webhook_events' => 'Event Webhook yang Diperlukan',
        'features' => 'Fitur',
        'supported_features' => 'Fitur yang Didukung',
        'secret_key' => 'Secret Key',
        'webhook_secret' => 'Webhook Secret',
        'webhook_signing_secret' => 'Webhook Signing Secret',
        'optional' => 'Opsional',

        // SSL Warning
        'ssl_warning' => 'Peringatan:',
        'ssl_warning_stripe' => 'Situs Anda tidak menggunakan HTTPS. Stripe memerlukan HTTPS untuk webhook dan penggunaan produksi.',
        'ssl_warning_paypal' => 'Situs Anda tidak menggunakan HTTPS. Webhook PayPal memerlukan koneksi HTTPS yang aman. Silakan aktifkan SSL/TLS sebelum go live.',
        'ssl_warning_paystack' => 'Situs Anda tidak menggunakan HTTPS. Webhook Paystack memerlukan koneksi HTTPS yang aman. Silakan aktifkan SSL/TLS sebelum go live.',

        // Stripe
        'stripe' => [
            'get_started' => 'Mulai dengan Stripe',
            'get_api_keys' => 'Dapatkan kunci API Anda dari',
            'dashboard_link' => 'Dasbor Stripe → Developers → API Keys',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Gunakan kunci tes (sk_test_) untuk pengujian, kunci live (sk_live_) untuk produksi',
            'webhook_url_help' => 'Tambahkan URL ini di Dasbor Stripe → Developers → Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Dapatkan ini setelah membuat endpoint webhook di Dasbor Stripe',
            'events_help' => 'Pilih event ini saat membuat endpoint webhook Anda:',
            'feature_currencies' => '135+ mata uang didukung secara global',
            'feature_intervals' => 'Semua interval tagihan didukung',
            'feature_renewal' => 'Perpanjangan langganan otomatis',
            'feature_customer_management' => 'Manajemen pelanggan',
            'feature_signature_verification' => 'Verifikasi tanda tangan webhook',
            'feature_refund' => 'Penanganan pengembalian dana',
            'feature_sca' => 'Sesuai dengan Strong Customer Authentication (SCA)',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'Client ID',
            'client_id_help' => 'Dapatkan ini dari PayPal Developer Dashboard',
            'client_secret' => 'Client Secret',
            'client_secret_help' => 'Jaga kerahasiaan ini dan jangan pernah dibagikan secara publik',
            'sandbox_mode' => 'Mode Sandbox',
            'sandbox_mode_help' => 'Aktifkan untuk pengujian dengan PayPal Sandbox. Nonaktifkan untuk transaksi live.',
            'webhook_url_help' => 'Tambahkan URL ini ke pengaturan webhook PayPal Anda',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => 'Webhook ID dari PayPal Dashboard untuk verifikasi tanda tangan (diperlukan untuk keamanan)',
            'events_help' => 'Pastikan untuk mengaktifkan event ini di konfigurasi webhook PayPal Anda:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Mulai dengan Razorpay',
            'get_api_keys' => 'Dapatkan kunci API Anda dari',
            'dashboard_link' => 'Dasbor Razorpay → Settings → API Keys',
            'key_id' => 'Key ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Gunakan kunci tes (rzp_test_) untuk pengujian, kunci live (rzp_live_) untuk produksi',
            'key_secret' => 'Key Secret',
            'key_secret_help' => 'Jaga kerahasiaan ini dan jangan pernah dibagikan secara publik',
            'webhook_url_help' => 'Tambahkan URL ini di Dasbor Razorpay → Settings → Webhooks',
            'webhook_secret_placeholder' => 'Masukkan webhook secret',
            'webhook_secret_help' => 'Dapatkan ini dari Dasbor Razorpay setelah membuat webhook',
            'events_help' => 'Aktifkan event ini di Dasbor Razorpay → Settings → Webhooks:',
            'feature_currencies' => '100+ mata uang didukung',
            'feature_intervals' => 'Semua interval tagihan (harian, mingguan, bulanan, tahunan)',
            'feature_payment_methods' => 'UPI, Kartu, NetBanking, Wallet, EMI',
            'feature_renewal' => 'Perpanjangan langganan otomatis',
            'feature_signature_verification' => 'Verifikasi tanda tangan webhook',
            'feature_refund' => 'Penanganan pengembalian dana',
            'feature_decimal' => 'Dukungan mata uang tiga desimal (KWD, BHD, dll.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Mulai dengan Paystack',
            'get_api_keys' => 'Dapatkan kunci API Anda dari',
            'dashboard_link' => 'Dasbor Paystack → Settings → API Keys & Webhooks',
            'secret_key_help' => 'Dapatkan ini dari Dasbor Paystack (gunakan kunci tes untuk pengujian, kunci live untuk produksi)',
            'webhook_url_help' => 'Tambahkan URL ini ke pengaturan webhook Paystack Anda',
            'webhook_secret_help' => 'Opsional: Untuk verifikasi tanda tangan webhook (disarankan untuk produksi)',
            'webhook_secret_placeholder' => 'Biarkan kosong untuk melewati verifikasi tanda tangan',
            'events_help' => 'Aktifkan event ini di Dasbor Paystack → Settings → API Keys & Webhooks:',
            'feature_currencies' => 'Mata Uang: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Interval: Harian, Mingguan, Bulanan (1, 3, 6 bulan), Tahunan',
            'feature_renewal' => 'Perpanjangan langganan otomatis',
            'feature_signature_verification' => 'Verifikasi tanda tangan webhook',
            'feature_interval_limitation' => 'Dukungan interval terbatas (lihat dokumentasi)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Mulai dengan Crypto.com Pay',
            'get_api_keys' => 'Dapatkan kredensial API Anda dari',
            'dashboard_link' => 'Dasbor Crypto.com Pay',
            'monthly_only_title' => 'Hanya Interval Bulanan',
            'monthly_only_description' => 'Crypto.com Pay saat ini hanya mendukung interval tagihan bulanan. Langganan harian, mingguan, dan tahunan tidak didukung.',
            'secret_key_placeholder' => 'Masukkan secret key Crypto.com Pay Anda',
            'secret_key_help' => 'Dapatkan ini dari Dasbor Crypto.com Pay',
            'webhook_url_help' => 'Tambahkan URL ini ke pengaturan webhook Crypto.com Pay Anda',
            'webhook_secret_placeholder' => 'Masukkan webhook signing secret',
            'webhook_secret_help' => 'Diperlukan untuk verifikasi tanda tangan webhook',
            'events_help' => 'Aktifkan event ini di Dasbor Crypto.com Pay:',
            'feature_crypto_fiat' => 'Terima pembayaran cryptocurrency dan fiat',
            'feature_currencies' => '30+ mata uang didukung',
            'feature_renewal' => 'Perpanjangan langganan otomatis',
            'feature_signature_verification' => 'Verifikasi tanda tangan webhook HMAC SHA-256',
            'feature_monthly_only' => 'Hanya interval bulanan (harian/mingguan/tahunan tidak didukung)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Persetujuan Manual Diperlukan',
            'manual_approval_description' => 'Pembayaran transfer bank memerlukan verifikasi manual. Pengguna akan melihat instruksi di bawah setelah memulai pembayaran. Admin harus menyetujui atau menolak pembayaran di',
            'transactions_link' => 'Transaksi',
            'instructions_title' => 'Instruksi Transfer Bank',
            'instructions_label' => 'Instruksi untuk Pengguna',
            'instructions_placeholder' => "Masukkan detail rekening bank dan instruksi transfer Anda di sini...\n\nContoh:\n\nNama Bank: Bank ABC\nNama Akun: Nama Perusahaan Anda\nNomor Rekening: 123456789\nKode Swift: ABCDEFGH\nReferensi: [Pengguna akan melihat ID langganan mereka]\n\nHarap sertakan ID langganan Anda dalam referensi pembayaran dan kirim bukti pembayaran ke billing@perusahaananda.com",
            'instructions_help' => 'Instruksi ini akan ditampilkan kepada pengguna setelah mereka memilih paket. Sertakan detail rekening bank, format referensi, dan langkah verifikasi apa pun.',
            'workflow_title' => 'Cara Kerja Pembayaran Transfer Bank:',
            'workflow_step_1' => 'Pengguna memilih paket dan memilih Transfer Bank sebagai metode pembayaran',
            'workflow_step_2' => 'Langganan dan transaksi tertunda dibuat',
            'workflow_step_3' => 'Pengguna melihat instruksi yang Anda konfigurasi di atas',
            'workflow_step_4' => 'Pengguna menyelesaikan transfer bank secara manual',
            'workflow_step_5' => 'Admin menerima notifikasi pembayaran tertunda',
            'workflow_step_6' => 'Admin menyetujui pembayaran → langganan diaktifkan dan kredit diisi ulang',
            'workflow_step_7' => 'Admin menolak pembayaran → langganan dan transaksi dihapus',
            'feature_currencies' => 'Semua mata uang didukung',
            'feature_intervals' => 'Semua interval tagihan didukung (harian, mingguan, bulanan, tahunan)',
            'feature_simple_setup' => 'Setup sederhana - tidak diperlukan kredensial API',
            'feature_manual_verification' => 'Verifikasi manual untuk keamanan',
            'feature_no_fees' => 'Tanpa biaya transaksi atau ketergantungan pihak ketiga',
            'feature_admin_approval' => 'Memerlukan persetujuan admin untuk setiap pembayaran',
            'feature_no_renewal' => 'Tidak ada perpanjangan langganan otomatis',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Kredit build tidak terbatas',
    'feature_build_credits' => ':count kredit build',
    'feature_all_builders' => 'Akses ke semua builder aktif',
    'feature_builder_access' => 'Akses builder',
    'feature_single_builder' => 'Akses ke satu builder',
    'feature_multiple_builders' => 'Akses ke :count builder',
    'feature_custom_code' => 'Injeksi CSS/JS kustom',
    'feature_api_access' => 'Akses API',
    'feature_unlimited_hosted_pages' => 'Halaman hosted tidak terbatas',
    'feature_hosted_pages' => ':count halaman hosted per aplikasi',
    'feature_hosted_pages_disabled' => 'Halaman hosted',
    'feature_unlimited_ai_chat' => 'Chat AI Tidak Terbatas',
    'feature_ai_tokens' => ':count token AI/bulan',
    'feature_own_ai_key' => 'Gunakan kunci API AI sendiri',
    'feature_ai_chat' => 'Asisten Chat AI',

    // Impersonation
    'impersonate' => 'Menyamar',
    'impersonate_user' => 'Menyamar sebagai Pengguna',
    'impersonation_started' => 'Sekarang menyamar sebagai :name',
    'impersonation_stopped' => 'Penyamaran berakhir. Selamat datang kembali!',
    'impersonating_as' => 'Melihat sebagai :name',
    'exit_impersonation' => 'Keluar',
    'return_to_admin' => 'Kembali ke Admin',
    'not_impersonating' => 'Saat ini tidak menyamar sebagai pengguna manapun.',
    'admin_blocked_during_impersonation' => 'Area admin diblokir saat menyamar. Keluar dari penyamaran terlebih dahulu.',
    'impersonation_disabled_demo' => 'Penyamaran dinonaktifkan dalam mode demo.',
    'only_admins_can_impersonate' => 'Hanya administrator yang dapat menyamar sebagai pengguna.',
];
