<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Landing Page Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used throughout the landing page
    | components for various messages and labels.
    |
    */

    // Hero Section
    'hero' => [
        'pill_no_coding' => 'Keine Programmierung erforderlich',
        'pill_5_minute_setup' => 'Einrichtung in 5 Minuten',
        'pill_free_tier' => 'Kostenlose Version verfügbar',
        'headline' => 'Native Apps erstellen',
        'headline_highlight' => 'in Minuten',
        'subheadline' => 'Verwandeln Sie Ihre Website in native Apps für jede Plattform.',
        'subheadline_ai' => 'KI-gestützte',
        'subheadline_features' => 'Konfiguration, individuelles Branding, Push-Benachrichtigungen und automatisierte Builds. Keine Programmierung erforderlich.',
        'cta_get_started' => 'Kostenlos starten',
        'cta_view_pricing' => 'Preise ansehen',
        'stat_developers' => 'Entwickler',
        'stat_apps_built' => 'Erstellte Apps',
        'stat_builds_generated' => 'Generierte Builds',
        'rating_text' => '4,9/5 aus über 200 Bewertungen',
        'phone_app_name' => 'Meine App',
        'phone_app_type' => 'Mobil',
        'laptop_title' => 'Meine App — Dashboard',
    ],

    // Features Section
    'features' => [
        'title' => 'Alles, was Sie zum Erstellen großartiger Apps brauchen',
        'subtitle' => 'Leistungsstarke Funktionen und Tools, um Ihre Website in professionelle native Anwendungen zu verwandeln, ohne eine einzige Zeile Code zu schreiben.',

        'multi_platform_title' => 'Multi-Plattform-Unterstützung',
        'multi_platform_desc' => 'Erstellen Sie native Apps für Android, Windows, macOS und Linux. Generieren Sie plattformspezifische Pakete, die für die Verteilung in jedem App Store bereit sind.',

        'easy_config_title' => 'Einfache Konfiguration',
        'easy_config_desc' => 'Intuitive Benutzeroberfläche zur Anpassung von App-Design, Navigation, Farben, Icons, Startbildschirmen und mehr ohne Programmierung.',

        'branding_title' => 'Vollständige Branding-Kontrolle',
        'branding_desc' => 'Passen Sie App-Icons, Startbildschirme, Themes, Farben an und fügen Sie benutzerdefiniertes HTML, CSS und JavaScript für volle Kontrolle hinzu.',

        'push_notifications_title' => 'Push-Benachrichtigungen',
        'push_notifications_desc' => 'Erreichen Sie Benutzer mit Firebase Cloud Messaging Push-Benachrichtigungen. Senden Sie gezielte Nachrichten direkt von Ihrem Dashboard an Ihre App-Benutzer.',

        'build_system_title' => 'Automatisiertes Build-System',
        'build_system_desc' => 'Erstellen Sie Ihre Apps mit einem Klick. Unser verteiltes Build-System generiert automatisch plattformspezifische Pakete, bereit für die Verteilung.',

        'app_signing_title' => 'Sichere App-Signierung',
        'app_signing_desc' => 'Laden Sie Signaturzertifikate sicher hoch und verwalten Sie diese. Signieren Sie Ihre Release-Builds für die App-Store-Verteilung mit Vertrauen.',

        'version_management_title' => 'Versionsverwaltung',
        'version_management_desc' => 'Verwalten Sie mehrere App-Versionen mit Build-Verlauf. Verfolgen Sie Änderungen, machen Sie bei Bedarf Rollbacks und behalten Sie mühelos die Versionskontrolle.',

        'qr_testing_title' => 'QR-Code-Tests',
        'qr_testing_desc' => 'Testen Sie Ihre Apps sofort mit QR-Code-Downloads. Teilen Sie Builds mit Testern und Kunden, bevor Sie in App Stores veröffentlichen.',

        'build_tracking_title' => 'Build-Verfolgung',
        'build_tracking_desc' => 'Überwachen Sie den Build-Status in Echtzeit mit detaillierten Protokollen. Verfolgen Sie Build-Dauer, Fehler und laden Sie jederzeit frühere Versionen herunter.',

        'ai_assistant_title' => 'KI-gestützter Assistent',
        'ai_assistant_desc' => 'Erhalten Sie intelligente Hilfe bei der Konfiguration Ihrer App. Unser KI-Assistent kann automatisch Navigation, Farben und Einstellungen basierend auf Ihrer Website einrichten.',

        'api_access_title' => 'API-Zugang',
        'api_access_desc' => 'Integrieren Sie sich in Ihren Workflow mit unserer umfassenden API. Automatisieren Sie App-Erstellung, lösen Sie Builds aus und verwalten Sie Benachrichtigungen programmatisch.',

        'hosted_pages_title' => 'Gehostete Seiten',
        'hosted_pages_desc' => 'Betten Sie benutzerdefinierte HTML-Seiten direkt in Ihre App ein. Erstellen Sie Über-Seiten, FAQs, Nutzungsbedingungen und mehr mit voller Design-Kontrolle.',
    ],

    // How It Works Section
    'how_it_works' => [
        'default_title' => 'So funktioniert es',
        'default_subtitle' => 'Erstellen Sie Ihre mobile App in 4 einfachen Schritten',

        'step1_title' => 'URL eingeben',
        'step1_desc' => 'Fügen Sie Ihre Website-URL ein und wir analysieren sie automatisch für einen schnellen Start.',

        'step2_title' => 'Design anpassen',
        'step2_desc' => 'Wählen Sie Farben, Icons, Startbildschirme und Navigationsstil. Nutzen Sie KI-Unterstützung für schnelle Einrichtung.',

        'step3_title' => 'App erstellen',
        'step3_desc' => 'Ein-Klick-Build mit unserem verteilten System. Erhalten Sie native Builds in Minuten.',

        'step4_title' => 'Herunterladen & Veröffentlichen',
        'step4_desc' => 'Laden Sie Ihre App herunter oder scannen Sie den QR-Code zum Testen. Bereit für die App-Store-Veröffentlichung.',
    ],

    // Pricing Section
    'pricing' => [
        'default_title' => 'Einfache, transparente Preise',
        'default_description' => 'Wählen Sie den perfekten Tarif für Ihre Bedürfnisse. Alle Tarife beinhalten Kernfunktionen mit unterschiedlichen Build-Credit-Zuweisungen.',
        'default_popular_badge' => 'Am beliebtesten',
        'default_free_text' => 'Kostenlos',
        'default_no_plans' => 'Preispläne kommen bald. Bitte schauen Sie später wieder vorbei.',
        'start_free' => 'Kostenlos starten',
        'go_pro' => 'Pro werden',
        'get_enterprise' => 'Enterprise erhalten',
    ],

    // Testimonials Section
    'testimonials' => [
        'default_title' => 'Was unsere Kunden sagen',
        'default_subtitle' => 'Schließen Sie sich Tausenden zufriedener Entwickler und Unternehmen an',
        'anonymous' => 'Anonym',
    ],

    // CTA Section
    'cta' => [
        'title' => 'Beginnen Sie heute mit dem Erstellen Ihrer App',
        'subtitle' => 'Schließen Sie sich Tausenden von Entwicklern und Unternehmen an, die :site_name vertrauen, um ihre Apps zu erstellen. Keine Kreditkarte erforderlich.',
        'button' => 'Kostenlos starten',
    ],

    // Footer Section
    'footer' => [
        'tagline' => 'Erstellen Sie native Apps aus Ihrer Website in Minuten. Professioneller App-Builder ohne Programmierung.',
        'privacy_policy' => 'Datenschutzerklärung',
        'terms_of_service' => 'Nutzungsbedingungen',
        'cookie_policy' => 'Cookie-Richtlinie',
        'copyright' => '© :year. Alle Rechte vorbehalten.',
    ],

    // Social Proof Section
    'social_proof' => [
        'happy_developers' => 'Zufriedene Entwickler',
        'apps_created' => 'Erstellte Apps',
        'builds_generated' => 'Generierte Builds',
    ],

    // Logos Section
    'logos' => [
        'title' => 'Sie sind in guter Gesellschaft',
    ],

    // Page Titles
    'page_title' => 'Native Mobile Apps in Minuten erstellen',
];
