<?php

namespace App\Plugins\Platforms\AndroidWebView\Livewire;

use App\Models\App;
use Livewire\Attributes\On;
use Livewire\Component;

class DeleteDrawerLogoLightModal extends Component
{
    public App $app;

    public $showModal = false;

    #[On('delete-drawer-logo-light')]
    public function openModal()
    {
        $this->showModal = true;
    }

    public function confirmDelete()
    {
        try {
            if ($this->app->androidWebViewConfig->drawer_logo_light) {
                \Storage::disk('public')->delete($this->app->androidWebViewConfig->drawer_logo_light);

                $this->app->androidWebViewConfig->update(['drawer_logo_light' => null]);

                $this->showModal = false;

                $this->dispatch('show-toast',
                    type: 'success',
                    message: __('platform.toast.drawer_logo_light_deleted')
                );

                $this->dispatch('settings-updated');
            }
        } catch (\Exception $e) {
            $this->dispatch('show-toast',
                type: 'error',
                message: __('platform.toast.drawer_logo_delete_failed')
            );
        }
    }

    public function closeModal()
    {
        $this->showModal = false;
    }

    public function render()
    {
        return view('plugins.android-webview::livewire.delete-drawer-logo-light-modal');
    }
}
